/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.removal.impl.servlets;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.model.WorkflowModel;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Arrays;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;

@SlingServlet(methods={"GET"}, resourceTypes={"acs-commons/components/utilities/workflow-remover"}, selectors={"init"}, extensions={"json"})
public class InitServlet
extends SlingSafeMethodsServlet {
    private static final String[] WORKFLOW_STATUSES = new String[]{"COMPLETED", "ABORTED", "RUNNING", "SUSPENDED", "STALE"};
    @Reference
    private WorkflowService workflowService;

    public final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        JsonObject json = new JsonObject();
        try {
            json.add("form", (JsonElement)this.getFormJSONObject(request.getResourceResolver()));
            Gson gson = new Gson();
            gson.toJson((JsonElement)json, (Appendable)response.getWriter());
        }
        catch (Exception e) {
            response.setStatus(500);
            response.getWriter().write(e.getMessage());
        }
    }

    private JsonObject getFormJSONObject(ResourceResolver resourceResolver) throws WorkflowException {
        JsonObject json = new JsonObject();
        WorkflowSession workflowSession = this.workflowService.getWorkflowSession((Session)resourceResolver.adaptTo(Session.class));
        WorkflowModel[] workflowModels = workflowSession.getModels();
        JsonArray models = new JsonArray();
        json.add("workflowModels", (JsonElement)models);
        for (WorkflowModel workflowModel : workflowModels) {
            JsonObject jsonWorkflow = new JsonObject();
            jsonWorkflow.addProperty("title", workflowModel.getTitle());
            jsonWorkflow.addProperty("id", workflowModel.getId());
            models.add((JsonElement)jsonWorkflow);
        }
        Gson gson = new Gson();
        json.add("statuses", gson.toJsonTree(Arrays.asList(WORKFLOW_STATUSES)));
        return json;
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }
}

