/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.removal.impl.servlets;

import com.adobe.acs.commons.json.JsonObjectUtil;
import com.adobe.acs.commons.workflow.bulk.removal.WorkflowInstanceRemover;
import com.adobe.acs.commons.workflow.bulk.removal.WorkflowRemovalForceQuitException;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/workflow-remover"}, selectors={"remove"}, extensions={"json"})
public class RemoveServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(RemoveServlet.class);
    private static final String PARAM_BATCH_SIZE = "batchSize";
    private static final String PARAM_WORKFLOW_STATUSES = "statuses";
    private static final String PARAM_WORKFLOW_MODELS = "models";
    private static final String PARAM_WORKFLOW_PAYLOADS = "payloads";
    private static final String PARAM_OLDER_THAN = "olderThan";
    private static final String PARAM_MAX_DURATION = "maxDuration";
    private static final int MS_IN_SECOND = 1000;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static final int DEFAULT_MAX_DURATION = 0;
    @Reference
    private WorkflowInstanceRemover workflowInstanceRemover;

    public final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block9: {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            ArrayList<String> statuses = new ArrayList<String>();
            ArrayList<String> models = new ArrayList<String>();
            ArrayList<Pattern> payloads = new ArrayList<Pattern>();
            Calendar olderThan = null;
            try {
                int maxDuration;
                int batchSize;
                int i;
                JsonObject params = JsonObjectUtil.toJsonObject(request.getParameter("params"));
                JsonArray jsonArray = params.getAsJsonArray(PARAM_WORKFLOW_STATUSES);
                for (i = 0; i < jsonArray.size(); ++i) {
                    statuses.add(jsonArray.get(i).getAsString());
                }
                jsonArray = params.getAsJsonArray(PARAM_WORKFLOW_MODELS);
                for (i = 0; i < jsonArray.size(); ++i) {
                    models.add(jsonArray.get(i).getAsString());
                }
                jsonArray = params.getAsJsonArray(PARAM_WORKFLOW_PAYLOADS);
                for (i = 0; i < jsonArray.size(); ++i) {
                    JsonObject tmp = jsonArray.get(i).getAsJsonObject();
                    String pattern = JsonObjectUtil.getString(tmp, "pattern");
                    if (!StringUtils.isNotBlank((String)pattern)) continue;
                    payloads.add(Pattern.compile(pattern));
                }
                Long ts = JsonObjectUtil.getLong(params, PARAM_OLDER_THAN);
                if (ts != null && ts > 0L) {
                    olderThan = Calendar.getInstance();
                    olderThan.setTimeInMillis(ts * 1000L);
                }
                if ((batchSize = JsonObjectUtil.getInteger(params, PARAM_BATCH_SIZE).intValue()) < 1) {
                    batchSize = 1000;
                }
                if ((maxDuration = JsonObjectUtil.getInteger(params, PARAM_MAX_DURATION).intValue()) < 1) {
                    maxDuration = 0;
                }
                this.workflowInstanceRemover.removeWorkflowInstances(request.getResourceResolver(), models, statuses, payloads, olderThan, batchSize, maxDuration);
            }
            catch (WorkflowRemovalForceQuitException e) {
                response.setStatus(599);
                response.getWriter().write("Workflow removal force quit");
            }
            catch (Exception e) {
                log.error("An error occurred while attempting to remove workflow instances.", (Throwable)e);
                response.setStatus(500);
                if (response.getWriter() == null) break block9;
                response.getWriter().write(e.getMessage());
            }
        }
    }

    protected void bindWorkflowInstanceRemover(WorkflowInstanceRemover workflowInstanceRemover) {
        this.workflowInstanceRemover = workflowInstanceRemover;
    }

    protected void unbindWorkflowInstanceRemover(WorkflowInstanceRemover workflowInstanceRemover) {
        if (this.workflowInstanceRemover == workflowInstanceRemover) {
            this.workflowInstanceRemover = null;
        }
    }
}

