/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.process.impl;

import com.adobe.acs.commons.workflow.WorkflowPackageManager;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="ACS AEM Commons - Workflow Process - DAM Metadata Property Reset", description="Replaces DAM Asset metadata properties with other values from the metadata node")
@Properties(value={@Property(label="Workflow Label", name="process.label", value={"DAM Metadata Property Reset"}, description="Replaces DAM Asset metadata properties with other values from the metadata node")})
@Service
public class DamMetadataPropertyResetProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(DamMetadataPropertyResetProcess.class);
    @Reference
    private WorkflowPackageManager workflowPackageManager;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    public final void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        String wfPayload = null;
        try (ResourceResolver resourceResolver = this.getResourceResolver(workflowSession.getSession());){
            wfPayload = (String)workItem.getWorkflowData().getPayload();
            List<String> payloads = this.workflowPackageManager.getPaths(resourceResolver, wfPayload);
            Map<String, String> srcDestMap = this.getProcessArgsMap(metaDataMap);
            for (String payload : payloads) {
                Asset asset = DamUtil.resolveToAsset((Resource)resourceResolver.getResource(payload));
                if (asset == null) {
                    log.debug("Payload path [ {} ] does not resolve to an asset", (Object)payload);
                    continue;
                }
                String metadataPath = String.format("%s/%s/%s", asset.getPath(), "jcr:content", "metadata");
                Resource metadataResource = resourceResolver.getResource(metadataPath);
                if (metadataResource == null) {
                    log.error("Could not find the metadata node for Asset [ " + asset.getPath() + " ]");
                    throw new WorkflowException("Could not find the metadata node for Asset [ " + asset.getPath() + " ]");
                }
                ModifiableValueMap mvm = (ModifiableValueMap)metadataResource.adaptTo(ModifiableValueMap.class);
                for (Map.Entry<String, String> entry : srcDestMap.entrySet()) {
                    String srcProperty = entry.getValue();
                    String destProperty = entry.getKey();
                    if (mvm.get((Object)srcProperty) != null) {
                        mvm.remove((Object)destProperty);
                        mvm.put((Object)destProperty, mvm.get((Object)srcProperty));
                    } else if (mvm.containsKey((Object)srcProperty)) {
                        mvm.remove((Object)destProperty);
                    }
                    mvm.remove((Object)srcProperty);
                }
            }
        }
        catch (LoginException e) {
            throw new WorkflowException("Could not get a ResourceResolver object from the WorkflowSession", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new WorkflowException(String.format("Could not find the payload for '%s'", wfPayload), (Throwable)e);
        }
    }

    private Map<String, String> getProcessArgsMap(MetaDataMap metaDataMap) {
        String[] lines;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String processArgs = (String)metaDataMap.get("PROCESS_ARGS", (Object)"");
        for (String line : lines = StringUtils.split((String)processArgs, (String)",")) {
            String[] entry = StringUtils.split((String)line, (String)"=");
            if (entry.length != 2) continue;
            map.put(entry[0], entry[1]);
        }
        return map;
    }

    private ResourceResolver getResourceResolver(Session session) throws LoginException {
        HashMap<String, Session> authInfo = new HashMap<String, Session>();
        authInfo.put("user.jcr.session", session);
        return this.resourceResolverFactory.getResourceResolver(authInfo);
    }

    protected void bindWorkflowPackageManager(WorkflowPackageManager workflowPackageManager) {
        this.workflowPackageManager = workflowPackageManager;
    }

    protected void unbindWorkflowPackageManager(WorkflowPackageManager workflowPackageManager) {
        if (this.workflowPackageManager == workflowPackageManager) {
            this.workflowPackageManager = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

