/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.synthetic.impl;

import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowModel;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowRunner;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowStep;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticMetaDataMap;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflowData;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflowModelImpl;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflowProcess;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflowRunnerAccessor;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflowStepImpl;
import com.adobe.acs.commons.workflow.synthetic.impl.cq.SyntheticWorkItem;
import com.adobe.acs.commons.workflow.synthetic.impl.cq.SyntheticWorkflow;
import com.adobe.acs.commons.workflow.synthetic.impl.granite.SyntheticWorkflowSession;
import com.adobe.acs.commons.workflow.synthetic.impl.granite.exceptions.SyntheticCompleteWorkflowException;
import com.adobe.acs.commons.workflow.synthetic.impl.granite.exceptions.SyntheticRestartWorkflowException;
import com.adobe.acs.commons.workflow.synthetic.impl.granite.exceptions.SyntheticTerminateWorkflowException;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.exec.WorkItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@References(value={@Reference(referenceInterface=com.day.cq.workflow.exec.WorkflowProcess.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, bind="bindCqWorkflowProcesses", unbind="unbindCqWorkflowProcesses"), @Reference(referenceInterface=WorkflowProcess.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, bind="bindGraniteWorkflowProcesses", unbind="unbindGraniteWorkflowProcesses")})
@Service(value={SyntheticWorkflowRunner.class})
public class SyntheticWorkflowRunnerImpl
implements SyntheticWorkflowRunner {
    private static final Logger log = LoggerFactory.getLogger(SyntheticWorkflowRunnerImpl.class);
    private static final String UNSUPPORTED_OPERATION_MESSAGE = "Operation not supported by Synthetic Workflow";
    private static final String WORKFLOW_PROCESS_LABEL = "process.label";
    private static final int MAX_RESTART_COUNT = 3;
    private Map<String, SyntheticWorkflowProcess> workflowProcessesByLabel = new ConcurrentHashMap<String, SyntheticWorkflowProcess>();
    private Map<String, SyntheticWorkflowProcess> workflowProcessesByProcessName = new ConcurrentHashMap<String, SyntheticWorkflowProcess>();
    @Reference
    private WorkflowService aemWorkflowService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private ServiceRegistration accessorReg;

    @Override
    public final void execute(ResourceResolver resourceResolver, String payloadPath, String[] workflowProcessLabels) throws com.day.cq.workflow.WorkflowException {
        this.execute(resourceResolver, payloadPath, workflowProcessLabels, null, false, false);
    }

    public final void execute(ResourceResolver resourceResolver, String payloadPath, String[] workflowProcessLabels, Map<String, Map<String, Object>> processArgs, boolean autoSaveAfterEachWorkflowProcess, boolean autoSaveAtEnd) throws com.day.cq.workflow.WorkflowException {
        this.execute(resourceResolver, payloadPath, SyntheticWorkflowRunner.WorkflowProcessIdType.PROCESS_LABEL, workflowProcessLabels, processArgs, autoSaveAfterEachWorkflowProcess, autoSaveAtEnd);
    }

    public void execute(ResourceResolver resourceResolver, String payloadPath, List<SyntheticWorkflowStep> workflowSteps, boolean autoSaveAfterEachWorkflowProcess, boolean autoSaveAtEnd) throws com.day.cq.workflow.WorkflowException {
        long start = System.currentTimeMillis();
        int count = 0;
        while (true) {
            ++count;
            try {
                this.run(resourceResolver, payloadPath, workflowSteps, autoSaveAfterEachWorkflowProcess, autoSaveAtEnd);
                if (log.isInfoEnabled()) {
                    long duration = System.currentTimeMillis() - start;
                    log.info("Synthetic workflow execution of payload [ {} ] completed in [ {} ] ms", (Object)payloadPath, (Object)duration);
                }
                return;
            }
            catch (com.adobe.acs.commons.workflow.synthetic.impl.cq.exceptions.SyntheticRestartWorkflowException ex) {
                if (count < 3) {
                    log.info("Restarting CQ synthetic workflow for [ {} ]", (Object)payloadPath);
                    continue;
                }
                log.warn("Synthetic CQ workflow execution of payload [ {} ] reached max restart rate of [ {} ]", (Object)payloadPath, (Object)count);
                if (count < 3) continue;
                return;
            }
            break;
        }
    }

    public final void execute(ResourceResolver resourceResolver, String payloadPath, SyntheticWorkflowRunner.WorkflowProcessIdType workflowProcessIdType, String[] workflowProcessIds, Map<String, Map<String, Object>> processArgs, boolean autoSaveAfterEachWorkflowProcess, boolean autoSaveAtEnd) throws com.day.cq.workflow.WorkflowException {
        if (processArgs == null) {
            processArgs = new HashMap<String, Map<String, Object>>();
        }
        List<SyntheticWorkflowStep> workflowSteps = this.convertToSyntheticWorkflowSteps(workflowProcessIds, workflowProcessIdType, processArgs);
        this.execute(resourceResolver, payloadPath, workflowSteps, autoSaveAfterEachWorkflowProcess, autoSaveAtEnd);
    }

    @Override
    public final void execute(ResourceResolver resourceResolver, String payloadPath, SyntheticWorkflowModel syntheticWorkflowModel, boolean autoSaveAfterEachWorkflowProcess, boolean autoSaveAtEnd) throws com.day.cq.workflow.WorkflowException {
        String[] processNames = syntheticWorkflowModel.getWorkflowProcessNames();
        Map<String, Map<String, Object>> processConfigs = syntheticWorkflowModel.getSyntheticWorkflowModelData();
        this.execute(resourceResolver, payloadPath, SyntheticWorkflowRunner.WorkflowProcessIdType.PROCESS_NAME, processNames, processConfigs, autoSaveAfterEachWorkflowProcess, autoSaveAtEnd);
    }

    private void run(ResourceResolver resourceResolver, String payloadPath, List<SyntheticWorkflowStep> workflowSteps, boolean autoSaveAfterEachWorkflowProcess, boolean autoSaveAtEnd) throws com.day.cq.workflow.WorkflowException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        SyntheticWorkflowData workflowData = new SyntheticWorkflowData("JCR_PATH", payloadPath);
        SyntheticWorkflow cqWorkflow = new SyntheticWorkflow("Synthetic Workflow ( " + payloadPath + " )", workflowData);
        com.adobe.acs.commons.workflow.synthetic.impl.granite.SyntheticWorkflow graniteWorkflow = new com.adobe.acs.commons.workflow.synthetic.impl.granite.SyntheticWorkflow("Synthetic Workflow ( " + payloadPath + " )", workflowData);
        boolean terminated = false;
        for (SyntheticWorkflowStep workflowStep : workflowSteps) {
            SyntheticWorkflowProcess workflowProcess = SyntheticWorkflowRunner.WorkflowProcessIdType.PROCESS_LABEL.equals((Object)workflowStep.getIdType()) ? this.workflowProcessesByLabel.get(workflowStep.getId()) : this.workflowProcessesByProcessName.get(workflowStep.getId());
            if (workflowProcess != null) {
                long start = System.currentTimeMillis();
                try {
                    SyntheticMetaDataMap workflowProcessMetaDataMap = new SyntheticMetaDataMap(workflowStep.getMetadataMap());
                    if (SyntheticWorkflowProcess.Type.GRANITE.equals((Object)workflowProcess.getWorkflowType())) {
                        this.runGraniteWorkflowProcess(session, graniteWorkflow, workflowProcessMetaDataMap, workflowProcess);
                        continue;
                    }
                    if (SyntheticWorkflowProcess.Type.CQ.equals((Object)workflowProcess.getWorkflowType())) {
                        this.runCqWorkflowProcess(session, cqWorkflow, workflowProcessMetaDataMap, workflowProcess);
                        continue;
                    }
                    log.warn("Workflow process step is of an unknown type [ {} ]. Skipping.", (Object)workflowProcess.getWorkflowType());
                    continue;
                }
                catch (com.adobe.acs.commons.workflow.synthetic.impl.cq.exceptions.SyntheticTerminateWorkflowException ex) {
                    terminated = true;
                    log.info("Synthetic CQ workflow execution stopped via terminate for [ {} ]", (Object)payloadPath);
                    break;
                }
                catch (SyntheticTerminateWorkflowException ex) {
                    terminated = true;
                    log.info("Synthetic Granite workflow execution stopped via terminate for [ {} ]", (Object)payloadPath);
                    break;
                }
                catch (com.adobe.acs.commons.workflow.synthetic.impl.cq.exceptions.SyntheticRestartWorkflowException ex) {
                    throw ex;
                }
                catch (SyntheticRestartWorkflowException ex) {
                    throw new com.adobe.acs.commons.workflow.synthetic.impl.cq.exceptions.SyntheticRestartWorkflowException(ex.getMessage());
                }
                catch (com.day.cq.workflow.WorkflowException ex) {
                    throw ex;
                }
                catch (WorkflowException ex) {
                    throw new com.day.cq.workflow.WorkflowException((Throwable)ex);
                }
                finally {
                    try {
                        if (!terminated && autoSaveAfterEachWorkflowProcess && session.hasPendingChanges()) {
                            session.save();
                        }
                        log.debug("Executed synthetic workflow process [ {} ] on [ {} ] in [ " + String.valueOf(System.currentTimeMillis() - start) + " ] ms", (Object)workflowStep.getId(), (Object)payloadPath);
                        continue;
                    }
                    catch (RepositoryException e) {
                        log.error("Could not save at end of synthetic workflow process execution [ {} ] for payload path [ {} ]", (Object)workflowStep.getId(), (Object)payloadPath);
                        log.error("Synthetic workflow process save failed.", (Throwable)e);
                        throw new com.day.cq.workflow.WorkflowException((Throwable)e);
                    }
                }
            }
            log.error("Synthetic workflow runner retrieved a null Workflow Process for process.label [ {} ]", (Object)workflowStep.getId());
        }
        try {
            if (autoSaveAtEnd && session.hasPendingChanges()) {
                session.save();
            }
        }
        catch (RepositoryException e) {
            log.error("Could not complete save at end of synthetic workflow execution process [ {} ]", (Object)payloadPath, (Object)e);
            throw new com.day.cq.workflow.WorkflowException((Throwable)e);
        }
    }

    private void runCqWorkflowProcess(Session session, SyntheticWorkflow workflow, SyntheticMetaDataMap workflowProcessMetaDataMap, SyntheticWorkflowProcess workflowProcess) throws com.day.cq.workflow.WorkflowException {
        com.day.cq.workflow.WorkflowSession workflowSession = this.getCqWorkflowSession(session);
        SyntheticWorkItem workItem = new SyntheticWorkItem(workflow.getWorkflowData());
        workItem.setWorkflow(workflow);
        log.trace("Executing CQ synthetic workflow process [ {} ] on [ {} ]", workflowProcess.getProcessId(), workflow.getWorkflowData().getPayload());
        try {
            workflowProcess.getCqWorkflowProcess().execute((WorkItem)workItem, workflowSession, (com.day.cq.workflow.metadata.MetaDataMap)workflowProcessMetaDataMap);
            workItem.setTimeEnded(new Date());
        }
        catch (com.adobe.acs.commons.workflow.synthetic.impl.cq.exceptions.SyntheticCompleteWorkflowException ex) {
            workItem.setTimeEnded(new Date());
            log.trace(ex.getMessage());
        }
        catch (com.adobe.acs.commons.workflow.synthetic.impl.cq.exceptions.SyntheticTerminateWorkflowException ex) {
            workItem.setTimeEnded(new Date());
            log.trace(ex.getMessage());
            throw ex;
        }
    }

    private void runGraniteWorkflowProcess(Session session, com.adobe.acs.commons.workflow.synthetic.impl.granite.SyntheticWorkflow workflow, SyntheticMetaDataMap workflowProcessMetaDataMap, SyntheticWorkflowProcess workflowProcess) throws WorkflowException {
        SyntheticWorkflowSession workflowSession = this.getGraniteWorkflowSession(session);
        com.adobe.acs.commons.workflow.synthetic.impl.granite.SyntheticWorkItem workItem = new com.adobe.acs.commons.workflow.synthetic.impl.granite.SyntheticWorkItem(workflow.getWorkflowData());
        workItem.setWorkflow(workflow);
        log.trace("Executing Granite synthetic workflow process [ {} ] on [ {} ]", workflowProcess.getProcessId(), workflow.getWorkflowData().getPayload());
        try {
            workflowProcess.getGraniteWorkflowProcess().execute((com.adobe.granite.workflow.exec.WorkItem)workItem, (WorkflowSession)workflowSession, (MetaDataMap)workflowProcessMetaDataMap);
            workItem.setTimeEnded(new Date());
        }
        catch (SyntheticCompleteWorkflowException ex) {
            workItem.setTimeEnded(new Date());
            log.trace(ex.getMessage());
        }
        catch (SyntheticTerminateWorkflowException ex) {
            workItem.setTimeEnded(new Date());
            log.trace(ex.getMessage());
            throw ex;
        }
    }

    private List<SyntheticWorkflowStep> convertToSyntheticWorkflowSteps(String[] workflowProcessIds, SyntheticWorkflowRunner.WorkflowProcessIdType idType, Map<String, Map<String, Object>> processArgs) {
        ArrayList<SyntheticWorkflowStep> workflowSteps = new ArrayList<SyntheticWorkflowStep>();
        for (String workflowProcessId : workflowProcessIds) {
            workflowSteps.add(this.getSyntheticWorkflowStep(workflowProcessId, idType, processArgs.get(workflowProcessId)));
        }
        return workflowSteps;
    }

    @Override
    public final SyntheticWorkflowModel getSyntheticWorkflowModel(ResourceResolver resourceResolver, String workflowModelId, boolean ignoreIncompatibleTypes) throws com.day.cq.workflow.WorkflowException {
        com.day.cq.workflow.WorkflowSession workflowSession = this.aemWorkflowService.getWorkflowSession((Session)resourceResolver.adaptTo(Session.class));
        return new SyntheticWorkflowModelImpl(workflowSession, workflowModelId, ignoreIncompatibleTypes);
    }

    @Override
    public SyntheticWorkflowStep getSyntheticWorkflowStep(String id, SyntheticWorkflowRunner.WorkflowProcessIdType type) {
        return this.getSyntheticWorkflowStep(id, type, Collections.EMPTY_MAP);
    }

    @Override
    public SyntheticWorkflowStep getSyntheticWorkflowStep(String id, SyntheticWorkflowRunner.WorkflowProcessIdType type, Map<String, Object> metadataMap) {
        return new SyntheticWorkflowStepImpl(id, type, metadataMap);
    }

    public final void start() throws com.day.cq.workflow.WorkflowException {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    public final void stop() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    public final com.day.cq.workflow.WorkflowSession getWorkflowSession(Session session) {
        return this.getCqWorkflowSession(session);
    }

    public final com.day.cq.workflow.WorkflowSession getCqWorkflowSession(Session session) {
        return new com.adobe.acs.commons.workflow.synthetic.impl.cq.SyntheticWorkflowSession(this, session);
    }

    public final SyntheticWorkflowSession getGraniteWorkflowSession(Session session) {
        return new SyntheticWorkflowSession(this, session);
    }

    public final WorkflowService getAEMWorkflowService() {
        return this.aemWorkflowService;
    }

    public final ResourceResolver getResourceResolver(Session session) throws LoginException {
        HashMap<String, Session> authInfo = new HashMap<String, Session>();
        authInfo.put("user.jcr.session", session);
        return this.resourceResolverFactory.getResourceResolver(authInfo);
    }

    public final Dictionary<String, Object> getConfig() {
        return new Hashtable<String, Object>();
    }

    @Activate
    protected final void activate(BundleContext bundleContext) {
        this.accessorReg = bundleContext.registerService(SyntheticWorkflowRunnerAccessor.class.getName(), (Object)new SyntheticWorkflowRunnerAccessor(){

            @Override
            public SyntheticWorkflowRunner getSyntheticWorkflowRunner() {
                return SyntheticWorkflowRunnerImpl.this;
            }
        }, new Hashtable());
    }

    @Deactivate
    protected final void deactivate(Map<String, Object> config) {
        log.trace("Deactivating Synthetic Workflow Runner");
        this.workflowProcessesByLabel = new ConcurrentHashMap<String, SyntheticWorkflowProcess>();
        this.workflowProcessesByProcessName = new ConcurrentHashMap<String, SyntheticWorkflowProcess>();
        if (this.accessorReg != null) {
            this.accessorReg.unregister();
            this.accessorReg = null;
        }
    }

    protected final void bindCqWorkflowProcesses(com.day.cq.workflow.exec.WorkflowProcess service, Map<Object, Object> props) {
        this.bindSyntheticWorkflowProcesses(new SyntheticWorkflowProcess(service), props);
    }

    protected final void unbindCqWorkflowProcesses(com.day.cq.workflow.exec.WorkflowProcess service, Map<Object, Object> props) {
        this.unbindSyntheticWorkflowProcesses(new SyntheticWorkflowProcess(service), props);
    }

    protected final void bindGraniteWorkflowProcesses(WorkflowProcess service, Map<Object, Object> props) {
        this.bindSyntheticWorkflowProcesses(new SyntheticWorkflowProcess(service), props);
    }

    protected final void unbindGraniteWorkflowProcesses(WorkflowProcess service, Map<Object, Object> props) {
        this.unbindSyntheticWorkflowProcesses(new SyntheticWorkflowProcess(service), props);
    }

    protected final void bindSyntheticWorkflowProcesses(SyntheticWorkflowProcess process, Map<Object, Object> props) {
        if (process != null) {
            String processName;
            String label = PropertiesUtil.toString((Object)props.get(WORKFLOW_PROCESS_LABEL), null);
            if (label != null) {
                this.workflowProcessesByLabel.put(label, process);
                log.trace("Synthetic {} Workflow Runner added Workflow Process by Label [ {} ]", (Object)process.getWorkflowType(), (Object)label);
            }
            if ((processName = (String)process.getProcessId()) != null) {
                this.workflowProcessesByProcessName.put(processName, process);
                log.trace("Synthetic {} Workflow Runner added Workflow Process by Process Name [ {} ]", (Object)process.getWorkflowType(), (Object)processName);
            } else {
                log.trace("Process name is null for [ {} ]", (Object)label);
            }
        }
    }

    protected final void unbindSyntheticWorkflowProcesses(SyntheticWorkflowProcess process, Map<Object, Object> props) {
        if (process != null) {
            String processName;
            String label = PropertiesUtil.toString((Object)props.get(WORKFLOW_PROCESS_LABEL), null);
            if (label != null) {
                this.workflowProcessesByLabel.remove(label);
                log.trace("Synthetic {} Workflow Runner removed Workflow Process by Label [ {} ]", (Object)process.getWorkflowType(), (Object)label);
            }
            if ((processName = (String)process.getProcessId()) != null) {
                this.workflowProcessesByProcessName.remove(processName);
                log.trace("Synthetic {} Workflow Runner removed Workflow Process by Process Name [ {} ]", (Object)process.getWorkflowType(), (Object)processName);
            } else {
                log.trace("Process name is null for [ {} ]", (Object)label);
            }
        }
    }

    protected void bindAemWorkflowService(WorkflowService workflowService) {
        this.aemWorkflowService = workflowService;
    }

    protected void unbindAemWorkflowService(WorkflowService workflowService) {
        if (this.aemWorkflowService == workflowService) {
            this.aemWorkflowService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

