/*
 * #%L
 * ACS AEM Commons Bundle
 * %%
 * Copyright (C) 2018 Adobe
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

package com.adobe.acs.commons.assets;

/**
 * File extension mime type constants that AEM supports.
 * @see <a href="https://helpx.adobe.com/experience-manager/6-3/assets/using/assets-formats.html">Assets Supported Formats</a>
 */
public final class FileExtensionMimeTypeConstants {

    private FileExtensionMimeTypeConstants() {
        // Do nothing.
    }

    /**
     * .image mime type constant.
     */
    public static final String EXT_IMAGE = "image/s7asset";

    /**
     * .3g2 mime type constant.
     */
    public static final String EXT_3G2 = "video/3gpp2";

    /**
     * .3gp mime type constant.
     */
    public static final String EXT_3GP = "video/3gpp";

    /**
     * .aac mime type constant.
     */
    public static final String EXT_AAC = "audio/x-aac";

    /**
     * .afm mime type constant.
     */
    public static final String EXT_AFM = "application/x-font-type1";

    /**
     * .aiff mime type constant.
     */
    public static final String EXT_AIFF = "audio/x-aiff";

    /**
     * .avi mime type constant.
     */
    public static final String EXT_AVI = "video/x-msvideo";

    /**
     * .bmp mime type constant.
     */
    public static final String EXT_BMP = "image/bmp";

    /**
     * .css mime type constant.
     */
    public static final String EXT_CSS = "text/css";

    /**
     * .doc mime type constant.
     */
    public static final String EXT_DOC = "application/msword";

    /**
     * .docx mime type constant.
     */
    public static final String EXT_DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";

    /**
     * .ai, .eps and .ps mime type constant.
     */
    public static final String EXT_AI_EPS_PS = "application/postscript";

    /**
     * .eps #1 mime type constant.
     */
    public static final String EXT_EPS_1 = "application/eps";

    /**
     * .eps #2 mime type constant.
     */
    public static final String EXT_EPS_2 = "application/x-eps";

    /**
     * .eps image #1 mime type constant.
     */
    public static final String EXT_EPS_IMAGE_1 = "image/eps";

    /**
     * .eps image #2 mime type constant.
     */
    public static final String EXT_EPS_IMAGE_2 = "image/x-eps";

    /**
     * .epub mime type constant.
     */
    public static final String EXT_EPUB = "application/epub+zip";

    /**
     * .f4v mime type constant.
     */
    public static final String EXT_F4V = "video/x-f4v";

    /**
     * .fla and .swf mime type constant.
     */
    public static final String EXT_FLA_SWF = "application/x-shockwave-flash";

    /**
     * .flv mime type constant.
     */
    public static final String EXT_FLV = "video/x-flv";

    /**
     * .fpx mime type constant.
     */
    public static final String EXT_FPX = "image/vnd.fpx";

    /**
     * .gif mime type constant.
     */
    public static final String EXT_GIF = "image/gif";

    /**
     * .html mime type constant.
     */
    public static final String EXT_HTML = "text/html";

    /**
     * .icc and .icm mime type constant.
     */
    public static final String EXT_ICC_ICM = "application/vnd.iccprofile";

    /**
     * .indd mime type constant.
     */
    public static final String EXT_INDD = "application/x-indesign";

    /**
     * .jar mime type constant.
     */
    public static final String EXT_JAR = "application/java-archive";

    /**
     * .jpeg and .jpg mime type constant.
     */
    public static final String EXT_JPEG_JPG = "image/jpeg";

    /**
     * .m2v, .mpeg and .mpg mime type constant.
     */
    public static final String EXT_M2V_MPEG_MPG = "video/mpeg";

    /**
     * .m4v mime type constant.
     */
    public static final String EXT_M4V = "video/x-m4v";

    /**
     * .midi mime type constant.
     */
    public static final String EXT_MIDI = "audio/midi";

    /**
     * .mov mime type constant.
     */
    public static final String EXT_MOV = "video/quicktime";

    /**
     * .mp3 mime type constant.
     */
    public static final String EXT_MP3 = "audio/mpeg";

    /**
     * .mp4 mime type constant.
     */
    public static final String EXT_MP4 = "video/mp4";

    /**
     * .mts mime type constant.
     */
    public static final String EXT_MTS = "model/vnd.mts";

    /**
     * .ogg mime type constant.
     */
    public static final String EXT_OGG = "audio/ogg";

    /**
     * .ogv mime type constant.
     */
    public static final String EXT_OGV = "video/ogg";

    /**
     * .otf mime type constant.
     */
    public static final String EXT_OTF = "application/x-font-otf";

    /**
     * .pdf mime type constant.
     */
    public static final String EXT_PDF = "application/pdf";

    /**
     * .pfb and .pfm mime type constant.
     */
    public static final String EXT_PFB_PFM = "application/x-font-type1";

    /**
     * .pict mime type constant.
     */
    public static final String EXT_PICT = "image/x-pict";

    /**
     * .png mime type constant.
     */
    public static final String EXT_PNG = "image/png";

    /**
     * .ppt mime type constant.
     */
    public static final String EXT_PPT = "application/vnd.ms-powerpoint";

    /**
     * .pptx mime type constant.
     */
    public static final String EXT_PPTX = "application/vnd.openxmlformats-officedocument.presentationml.presentation";

    /**
     * .psd mime type constant.
     */
    public static final String EXT_PSD = "image/vnd.adobe.photoshop";

    /**
     * .rar mime type constant.
     */
    public static final String EXT_RAR = "application/x-rar-compressed";

    /**
     * .rtf mime type constant.
     */
    public static final String EXT_RTF = "application/rtf";

    /**
     * .svg mime type constant.
     */
    public static final String EXT_SVG = "image/svg+xml";

    /**
     * .tar mime type constant.
     */
    public static final String EXT_TAR = "application/x-tar";

    /**
     * .tif and .tiff mime type constant.
     */
    public static final String EXT_TIF_TIFF = "image/tiff";

    /**
     * .ttc and .ttf mime type constant.
     */
    public static final String EXT_TTC_TTF = "application/x-font-ttf";

    /**
     * .txt mime type constant.
     */
    public static final String EXT_TXT = "text/plain";

    /**
     * .vob mime type constant.
     */
    public static final String EXT_VOB = "video/dvd";

    /**
     * .vtt mime type constant.
     */
    public static final String EXT_VTT = "text/vtt";

    /**
     * .wav mime type constant.
     */
    public static final String EXT_WAV = "audio/x-wav";

    /**
     * .webm mime type constant.
     */
    public static final String EXT_WEBM = "video/webm";

    /**
     * .wma mime type constant.
     */
    public static final String EXT_WMA = "audio/x-ms-wma";

    /**
     * .wmv mime type constant.
     */
    public static final String EXT_WMV = "video/x-ms-wmv";

    /**
     * .xls mime type constant.
     */
    public static final String EXT_XLS = "application/vnd.ms-excel";

    /**
     * .xlsx mime type constant.
     */
    public static final String EXT_XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";

    /**
     * .xml mime type constant.
     */
    public static final String EXT_XML = "application/xml";

    /**
     * .zip mime type constant.
     */
    public static final String EXT_ZIP = "application/zip";
}
