/*
 * Decompiled with CFR 0.152.
 */
package acscommons.io.jsonwebtoken;

import acscommons.io.jsonwebtoken.Claims;
import acscommons.io.jsonwebtoken.Clock;
import acscommons.io.jsonwebtoken.CompressionCodecResolver;
import acscommons.io.jsonwebtoken.ExpiredJwtException;
import acscommons.io.jsonwebtoken.Header;
import acscommons.io.jsonwebtoken.Jws;
import acscommons.io.jsonwebtoken.Jwt;
import acscommons.io.jsonwebtoken.JwtHandler;
import acscommons.io.jsonwebtoken.MalformedJwtException;
import acscommons.io.jsonwebtoken.SignatureException;
import acscommons.io.jsonwebtoken.SigningKeyResolver;
import acscommons.io.jsonwebtoken.UnsupportedJwtException;
import java.security.Key;
import java.util.Date;

public interface JwtParser {
    public static final char SEPARATOR_CHAR = '.';

    public JwtParser requireId(String var1);

    public JwtParser requireSubject(String var1);

    public JwtParser requireAudience(String var1);

    public JwtParser requireIssuer(String var1);

    public JwtParser requireIssuedAt(Date var1);

    public JwtParser requireExpiration(Date var1);

    public JwtParser requireNotBefore(Date var1);

    public JwtParser require(String var1, Object var2);

    public JwtParser setClock(Clock var1);

    public JwtParser setAllowedClockSkewSeconds(long var1);

    public JwtParser setSigningKey(byte[] var1);

    public JwtParser setSigningKey(String var1);

    public JwtParser setSigningKey(Key var1);

    public JwtParser setSigningKeyResolver(SigningKeyResolver var1);

    public JwtParser setCompressionCodecResolver(CompressionCodecResolver var1);

    public boolean isSigned(String var1);

    public Jwt parse(String var1) throws ExpiredJwtException, MalformedJwtException, SignatureException, IllegalArgumentException;

    public <T> T parse(String var1, JwtHandler<T> var2) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException;

    public Jwt<Header, String> parsePlaintextJwt(String var1) throws UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException;

    public Jwt<Header, Claims> parseClaimsJwt(String var1) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException;

    public Jws<String> parsePlaintextJws(String var1) throws UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException;

    public Jws<Claims> parseClaimsJws(String var1) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException;
}

