/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.granite.ui.components.impl.include;

import com.adobe.acs.commons.util.TypeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public class NamespaceDecoratedValueMapBuilder {
    private final SlingHttpServletRequest request;
    private final Map<String, Object> copyMap;
    private final String[] namespacedProperties;
    static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(\\$\\{\\{([a-zA-Z0-9]+?)(:(.+?))??\\}\\})+?");
    static final Pattern PLACEHOLDER_TYPE_HINTED_PATTERN = Pattern.compile("(.*)\\$\\{\\{(\\(([a-zA-Z]+)\\)){1}([a-zA-Z0-9]+)(:(.+))?\\}\\}(.*)?");

    public NamespaceDecoratedValueMapBuilder(SlingHttpServletRequest request, Resource resource, String[] namespacedProperties) {
        this.request = request;
        this.copyMap = new HashMap<String, Object>((Map<String, Object>)resource.getValueMap());
        this.namespacedProperties = namespacedProperties;
        this.applyDynamicVariables();
        this.applyNameSpacing();
    }

    private void applyNameSpacing() {
        if (this.request.getAttribute("ACS_AEM_COMMONS_INCLUDE_NAMESPACE") != null) {
            for (String namespacedProp : this.namespacedProperties) {
                String adjusted;
                if (!this.copyMap.containsKey(namespacedProp)) continue;
                String originalValue = this.copyMap.get(namespacedProp).toString();
                String namespace = this.request.getAttribute("ACS_AEM_COMMONS_INCLUDE_NAMESPACE").toString();
                boolean containsDotSlash = StringUtils.contains((CharSequence)originalValue, (CharSequence)"./");
                if (containsDotSlash) {
                    String extracted = StringUtils.substringAfter((String)originalValue, (String)"./");
                    adjusted = "./" + namespace + "/" + extracted;
                } else {
                    adjusted = namespace + "/" + originalValue;
                }
                this.copyMap.put(namespacedProp, adjusted);
            }
        }
    }

    public ValueMap build() {
        return new ValueMapDecorator(this.copyMap);
    }

    private void applyDynamicVariables() {
        for (Map.Entry<String, Object> entry : this.copyMap.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            Object filtered = this.filter(entry.getValue().toString(), this.request);
            this.copyMap.put(entry.getKey(), filtered);
        }
    }

    private Object filter(String value, SlingHttpServletRequest request) {
        Object filtered = this.applyTypeHintedPlaceHolders(value, request);
        if (filtered != null) {
            return filtered;
        }
        return this.applyPlaceHolders(value, request);
    }

    private Object applyTypeHintedPlaceHolders(String value, SlingHttpServletRequest request) {
        Matcher matcher = PLACEHOLDER_TYPE_HINTED_PATTERN.matcher(value);
        if (matcher.find()) {
            String prefix = matcher.group(1);
            String typeHint = matcher.group(3);
            String paramKey = matcher.group(4);
            String defaultValue = matcher.group(6);
            String suffix = matcher.group(7);
            String requestParamValue = request.getAttribute("ACS_AEM_COMMONS_INCLUDE_PREFIX_" + paramKey) != null ? request.getAttribute("ACS_AEM_COMMONS_INCLUDE_PREFIX_" + paramKey).toString() : null;
            String chosenValue = StringUtils.defaultString(requestParamValue, (String)defaultValue);
            String finalValue = (String)StringUtils.defaultIfEmpty((CharSequence)prefix, (CharSequence)"") + chosenValue + (String)StringUtils.defaultIfEmpty((CharSequence)suffix, (CharSequence)"");
            return StringUtils.isNotEmpty((CharSequence)typeHint) ? this.castTypeHintedValue(typeHint, finalValue) : finalValue;
        }
        return null;
    }

    private String applyPlaceHolders(String value, SlingHttpServletRequest request) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(value);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String paramKey = matcher.group(2);
            String defaultValue = matcher.group(4);
            String requestParamValue = request.getAttribute("ACS_AEM_COMMONS_INCLUDE_PREFIX_" + paramKey) != null ? request.getAttribute("ACS_AEM_COMMONS_INCLUDE_PREFIX_" + paramKey).toString() : null;
            String chosenValue = StringUtils.defaultString(requestParamValue, (String)defaultValue);
            if (chosenValue == null) {
                chosenValue = "";
            }
            matcher.appendReplacement(buffer, chosenValue);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private Object castTypeHintedValue(String typeHint, String chosenValue) {
        Class clazz;
        switch (typeHint.toLowerCase()) {
            case "boolean": {
                clazz = Boolean.class;
                break;
            }
            case "long": {
                clazz = Long.class;
                break;
            }
            case "double": {
                clazz = Double.class;
                break;
            }
            default: {
                clazz = String.class;
            }
        }
        return TypeUtil.toObjectType(chosenValue, clazz);
    }
}

