/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import com.adobe.acs.commons.mcp.form.DialogProvider;
import com.adobe.acs.commons.mcp.impl.DialogResourceProviderImpl;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public interface DialogResourceProvider {
    public static final Map<Class, ServiceRegistration> registeredProviders = Collections.synchronizedMap(new HashMap());

    public Class getTargetClass();

    default public DialogProvider getDialogProvider() {
        return this.getTargetClass().getAnnotation(DialogProvider.class);
    }

    default public void doActivate(BundleContext bundleContext) throws InstantiationException, IllegalAccessException {
        DialogResourceProviderImpl provider = new DialogResourceProviderImpl(this.getTargetClass(), this.getDialogProvider());
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("provider.name", provider.getRoot());
        ((Dictionary)props).put("provider.root", provider.getRoot());
        ((Dictionary)props).put("provider.useResourceAccessSecurity", Boolean.FALSE);
        ServiceRegistration providerRegistration = bundleContext.registerService(ResourceProvider.class, (Object)provider, props);
        registeredProviders.put(this.getTargetClass(), providerRegistration);
    }

    default public void doDeactivate() {
        ServiceRegistration providerRegistration = registeredProviders.get(this.getTargetClass());
        if (providerRegistration != null) {
            providerRegistration.unregister();
        }
        registeredProviders.remove(this.getTargetClass());
    }

    public static String getServiceClassName(String modelClass) {
        String[] parts = modelClass.split("\\.");
        String name = "";
        String separator = ".";
        for (String part : parts) {
            char firstChar = part.charAt(0);
            String newSeparator = separator;
            if (firstChar >= 'A' && firstChar <= 'Z' && separator.equals(".")) {
                newSeparator = "$";
                name = name + ".impl";
            }
            if (name.length() > 0) {
                name = name + separator;
            }
            name = name + part;
            separator = newSeparator;
        }
        return name + "_dialogResourceProvider";
    }
}

