/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.FileUploadComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.SelectComponent;
import com.adobe.acs.commons.mcp.model.GenericReport;
import com.adobe.acs.commons.mcp.util.StringUtil;
import com.adobe.acs.commons.util.datadefinitions.ResourceDefinition;
import com.adobe.acs.commons.util.datadefinitions.ResourceDefinitionBuilder;
import com.adobe.acs.commons.util.datadefinitions.impl.BasicResourceDefinition;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagConstants;
import com.day.cq.tagging.TagManager;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagCreator
extends ProcessDefinition
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TagCreator.class);
    private static final long serialVersionUID = 4325471295421747160L;
    public static final String NAME = "Tag Creator";
    private final transient Map<String, ResourceDefinitionBuilder> resourceDefinitionBuilders;
    @FormField(name="Excel File", description="Provide the .xlsx file that defines the tag taxonomy", component=FileUploadComponent.class, options={"mimeTypes=application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "required"})
    public transient InputStream excelFile = null;
    @FormField(name="Primary Converter", description="This will be used first and the Fallback will only be used if this fails to generate a valid Tag definition.", component=SelectComponent.EnumerationSelector.class, options={"default=TITLE_AND_NODE_NAME", "required"})
    public TagBuilder primary = TagBuilder.TITLE_AND_NODE_NAME;
    @FormField(name="Fallback Converter", description="This is only invoked when the Primary cannot generate a valid Tag definition. If this can also not genreate a valid Tag definition then the row will be skipped.", component=SelectComponent.EnumerationSelector.class, options={"default=LOWERCASE_WITH_DASHES", "required"})
    public TagBuilder fallback = TagBuilder.LOWERCASE_WITH_DASHES;
    volatile transient HashMap<String, TagDefinition> tagDefinitions = new LinkedHashMap<String, TagDefinition>();
    private final transient GenericReport report = new GenericReport();
    private final transient ArrayList<EnumMap<ReportColumns, Object>> reportRows = new ArrayList();

    public TagCreator(Map<String, ResourceDefinitionBuilder> resourceDefinitionBuilders) {
        this.resourceDefinitionBuilders = resourceDefinitionBuilders;
    }

    @Override
    public void init() throws RepositoryException {
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        this.report.setName(instance.getName());
        instance.getInfo().setDescription(String.format("Create tags using [ %s -> %s ]", StringUtil.getFriendlyName(this.primary.name()), StringUtil.getFriendlyName(this.fallback.name())));
        instance.defineCriticalAction("Parse tags", rr, this::parseTags);
        instance.defineCriticalAction("Create tags", rr, this::importTags);
    }

    public void parseTags(ActionManager manager) throws Exception {
        manager.withResolver(rr -> {
            XSSFWorkbook workbook = new XSSFWorkbook(this.excelFile);
            XSSFSheet sheet = workbook.getSheetAt(0);
            Iterator rows = sheet.rowIterator();
            String tagsRootPath = new TagRootResolver((ResourceResolver)rr).getTagsLocationPath();
            if (tagsRootPath == null) {
                this.record(ReportRowSatus.FAILED_TO_PARSE, "Abandoning Tag parsing. Unable to determine AEM Tags root (/content/cq:tags vs /etc/tags). Please ensure the path exists and is accessible by the user running Tag Creator.", "N/A", "N/A");
                return;
            }
            block0: while (rows.hasNext()) {
                Cell cell;
                String cellValue;
                Row row = (Row)rows.next();
                Iterator cells = row.cellIterator();
                int cellIndex = 0;
                String previousTagId = null;
                while (cells.hasNext() && !StringUtils.isBlank((CharSequence)(cellValue = StringUtils.trimToNull((String)(cell = (Cell)cells.next()).getStringCellValue())))) {
                    TagDefinition tagDefinition = this.getTagDefinition(this.primary, cellIndex, cellValue, previousTagId, tagsRootPath);
                    if (tagDefinition == null) {
                        tagDefinition = this.getTagDefinition(this.fallback, cellIndex, cellValue, previousTagId, tagsRootPath);
                    }
                    if (tagDefinition == null) {
                        log.warn("Could not find a Tag Data Converter that accepts value [ {} ]; skipping...", (Object)cellValue);
                        this.record(ReportRowSatus.FAILED_TO_PARSE, cellValue, "", "");
                        continue block0;
                    }
                    ++cellIndex;
                    previousTagId = tagDefinition.getId();
                    if (this.tagDefinitions.get(tagDefinition.getId()) != null) continue;
                    this.tagDefinitions.put(tagDefinition.getId(), tagDefinition);
                }
            }
            log.info("Finished Parsing and collected [ {} ] tags for import.", (Object)this.tagDefinitions.size());
        });
    }

    public void importTags(ActionManager manager) {
        this.tagDefinitions.values().stream().forEach(tagDefinition -> {
            try {
                manager.withResolver(rr -> {
                    TagManager tagManager = (TagManager)rr.adaptTo(TagManager.class);
                    this.createTag((TagDefinition)tagDefinition, tagManager);
                });
            }
            catch (Exception e) {
                log.error("Unable to import tags via ACS Commons MCP - Tag Creator", (Throwable)e);
            }
        });
    }

    private void createTag(TagDefinition tagDefinition, TagManager tagManager) {
        try {
            ReportRowSatus status = tagManager.resolve(tagDefinition.getId()) == null ? ReportRowSatus.CREATED : ReportRowSatus.UPDATED_EXISTING;
            Tag tag = tagManager.createTag(tagDefinition.getId(), tagDefinition.getTitle(), tagDefinition.getDescription(), false);
            if (tag != null) {
                this.setTitles(tag, tagDefinition);
                this.record(status, tag.getTagID(), tag.getPath(), tag.getTitle());
                log.debug("Created tag [ {} -> {} ]", (Object)tagDefinition.getId(), (Object)tagDefinition.getTitle());
            } else {
                log.error("Tag [ {} ] is null", (Object)tagDefinition.getId());
            }
        }
        catch (Exception e) {
            this.record(ReportRowSatus.FAILED_TO_CREATE, tagDefinition.getId(), tagDefinition.getPath(), tagDefinition.getTitle());
            log.error("Unable to create tag [ {} -> {} ]", (Object)tagDefinition.getId(), (Object)tagDefinition.getTitle());
        }
    }

    private TagDefinition getTagDefinition(TagBuilder tagBuilder, int index, String value, String previousTagId, String tagsRootPath) {
        ResourceDefinitionBuilder resourceDefinitionBuilder = this.resourceDefinitionBuilders.get(tagBuilder.name());
        if (resourceDefinitionBuilder != null && resourceDefinitionBuilder.accepts(value)) {
            TagDefinition tagDefinition = new TagDefinition(resourceDefinitionBuilder.convert(value), tagsRootPath);
            switch (index) {
                case 0: {
                    tagDefinition.setId(tagDefinition.getName() + TagConstants.NAMESPACE_DELIMITER);
                    break;
                }
                case 1: {
                    tagDefinition.setId(previousTagId + tagDefinition.getName());
                    break;
                }
                default: {
                    tagDefinition.setId(previousTagId + "/" + tagDefinition.getName());
                }
            }
            return tagDefinition;
        }
        return null;
    }

    private void setTitles(Tag tag, TagDefinition tagDefinition) throws RepositoryException {
        Node node = (Node)tag.adaptTo(Node.class);
        if (node == null) {
            log.error("Tag [ {} ] could not be adapted to a Node", (Object)tagDefinition.getId());
            return;
        }
        if (!StringUtils.equals((CharSequence)tag.getTitle(), (CharSequence)tagDefinition.getTitle())) {
            node.setProperty("jcr:title", tagDefinition.getTitle());
        }
        if (!tagDefinition.getLocalizedTitles().isEmpty()) {
            Map<String, String> translationsMap = tagDefinition.getLocalizedTitles();
            for (Map.Entry<String, String> entry : translationsMap.entrySet()) {
                node.setProperty("jcr:title." + entry.getKey(), entry.getValue());
            }
        }
    }

    private void record(ReportRowSatus status, String tagId, String path, String title) {
        EnumMap<ReportColumns, String> row = new EnumMap<ReportColumns, String>(ReportColumns.class);
        row.put(ReportColumns.STATUS, StringUtil.getFriendlyName(status.name()));
        row.put(ReportColumns.TAG_ID, tagId);
        row.put(ReportColumns.TAG_PATH, path);
        row.put(ReportColumns.TAG_TITLE, title);
        this.reportRows.add(row);
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        this.report.setRows(this.reportRows, ReportColumns.class);
        this.report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    protected static final class TagRootResolver {
        private static final String CONTENT_LOCATION = "/content/cq:tags";
        private static final String ETC_LOCATION = "/etc/tags";
        private final String tagsLocationPath;

        public TagRootResolver(ResourceResolver resourceResolver) {
            TagsLocation tagsLocation = this.resolveTagsLocation(resourceResolver);
            this.tagsLocationPath = tagsLocation == TagsLocation.CONTENT ? CONTENT_LOCATION : (tagsLocation == TagsLocation.ETC ? ETC_LOCATION : (this.contentLocationExists(resourceResolver) ? CONTENT_LOCATION : (this.etcLocationExists(resourceResolver) ? ETC_LOCATION : null)));
        }

        public String getTagsLocationPath() {
            return this.tagsLocationPath;
        }

        private TagsLocation resolveTagsLocation(ResourceResolver resourceResolver) {
            TagManager tagManager = (TagManager)resourceResolver.adaptTo(TagManager.class);
            Tag[] namespaces = tagManager.getNamespaces();
            if (namespaces.length > 0) {
                Tag tag = namespaces[0];
                if (StringUtils.startsWith((CharSequence)tag.getPath(), (CharSequence)CONTENT_LOCATION)) {
                    return TagsLocation.CONTENT;
                }
                return TagsLocation.ETC;
            }
            return TagsLocation.UNKNOWN;
        }

        private boolean contentLocationExists(ResourceResolver resourceResolver) {
            return resourceResolver.getResource(CONTENT_LOCATION) != null;
        }

        private boolean etcLocationExists(ResourceResolver resourceResolver) {
            return resourceResolver.getResource(ETC_LOCATION) != null;
        }
    }

    protected static enum TagsLocation {
        ETC,
        CONTENT,
        UNKNOWN;

    }

    private final class TagDefinition
    extends BasicResourceDefinition {
        private final String tagsRootPath;

        public TagDefinition(ResourceDefinition resourceDefinition, String tagsRootPath) {
            super(resourceDefinition.getName());
            super.setId(resourceDefinition.getId());
            super.setDescription(resourceDefinition.getDescription());
            super.setTitle(resourceDefinition.getTitle());
            super.setLocalizedTitles(resourceDefinition.getLocalizedTitles());
            this.tagsRootPath = tagsRootPath;
        }

        @Override
        public String getPath() {
            if (this.getId() != null) {
                return this.tagsRootPath + StringUtils.replace((String)this.getId(), (String)":", (String)"/");
            }
            return null;
        }
    }

    public static enum ReportRowSatus {
        CREATED,
        UPDATED_EXISTING,
        FAILED_TO_PARSE,
        FAILED_TO_CREATE;

    }

    private static enum ReportColumns {
        STATUS,
        TAG_ID,
        TAG_PATH,
        TAG_TITLE;

    }

    public static enum TagBuilder {
        TITLE_TO_NODE_NAME,
        TITLE_AND_NODE_NAME,
        LOWERCASE_WITH_DASHES,
        LOCALIZED_TITLE,
        NONE;

    }
}

