/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.renovator;

import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingException;
import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingNode;
import com.adobe.acs.commons.mcp.impl.processes.renovator.ReplicatorQueue;
import com.adobe.acs.commons.mcp.impl.processes.renovator.Util;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.PageManagerFactory;
import com.day.cq.wcm.api.WCMException;
import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class MovingPage
extends MovingNode {
    PageManagerFactory pageManagerFactory;

    public MovingPage(PageManagerFactory pageManagerFactory) {
        this.pageManagerFactory = pageManagerFactory;
    }

    @Override
    public boolean isCopiedBeforeMove() {
        return false;
    }

    @Override
    public boolean isSupposedToBeReferenced() {
        return true;
    }

    @Override
    public boolean isAbleToHaveChildren() {
        return true;
    }

    @Override
    public void move(ReplicatorQueue replicatorQueue, ResourceResolver rr) throws IllegalAccessException, MovingException {
        PageManager manager = this.pageManagerFactory.getPageManager(rr);
        Field replicatorField = FieldUtils.getDeclaredField(manager.getClass(), (String)"replicator", (boolean)true);
        FieldUtils.writeField((Field)replicatorField, (Object)manager, (Object)replicatorQueue);
        String contentPath = this.getSourcePath() + "/" + "jcr:content";
        String destinationParent = StringUtils.substringBeforeLast((String)this.getDestinationPath(), (String)"/");
        try {
            Actions.retry(10, 500L, res -> {
                Util.waitUntilResourceFound(res, destinationParent);
                this.moveOrClonePage(rr, manager, contentPath, destinationParent, (ResourceResolver)res);
                this.movePageChildren(rr, (ResourceResolver)res);
            }).accept(rr);
        }
        catch (Exception e) {
            throw new MovingException(this.getSourcePath(), e);
        }
    }

    private void moveOrClonePage(ResourceResolver rr, PageManager manager, String contentPath, String destinationParent, ResourceResolver res) throws WCMException, PersistenceException {
        Resource source = rr.getResource(this.getSourcePath());
        if (Util.resourceExists(res, contentPath)) {
            manager.move(source, this.getDestinationPath(), this.getPreviousSibling(), true, true, Util.listToStringArray(this.getAllReferences()), Util.listToStringArray(this.getPublishedReferences()));
        } else if (!Util.resourceExists(res, this.getDestinationPath())) {
            Resource parent = res.getResource(destinationParent);
            res.create(parent, source.getName(), this.getClonedProperties(source));
        }
        res.commit();
        res.refresh();
    }

    private void movePageChildren(ResourceResolver rr, ResourceResolver res) throws MovingException {
        Resource source = rr.getResource(this.getSourcePath());
        try {
            if (source != null && source.hasChildren()) {
                for (Resource child : source.getChildren()) {
                    if (this.hasChild(child.getPath())) continue;
                    String childDestination = child.getPath().replaceAll(this.getSourcePath(), this.getDestinationPath());
                    String childDestinationParent = StringUtils.substringBeforeLast((String)childDestination, (String)"/");
                    if (Util.resourceExists(res, childDestination)) continue;
                    Util.waitUntilResourceFound(res, childDestinationParent);
                    res.move(child.getPath(), childDestination);
                }
                res.commit();
            }
        }
        catch (PersistenceException e) {
            throw new MovingException(this.getSourcePath(), e);
        }
    }
}

