/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import com.adobe.acs.commons.util.impl.ComponentDisabler;
import com.adobe.acs.commons.util.impl.ComponentDisablerDriver;
import org.apache.felix.scr.ScrService;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Property(name="service.ranking", intValue={100})
public class ComponentDisablerDriverFelix
implements ComponentDisablerDriver {
    private static final Logger log = LoggerFactory.getLogger(ComponentDisabler.class);
    @Reference
    private ScrService scr;

    @Override
    public void disable(String componentName) {
        for (org.apache.felix.scr.Component component : this.scr.getComponents(componentName)) {
            if (component.getState() == 1) continue;
            log.info("Component {} disabled by configuration (pid={}) ", (Object)component.getClassName(), (Object)component.getConfigurationPid());
            component.disable();
        }
    }

    protected void bindScr(ScrService scrService) {
        this.scr = scrService;
    }

    protected void unbindScr(ScrService scrService) {
        if (this.scr == scrService) {
            this.scr = null;
        }
    }
}

