/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Page Root Provider Configuration", description="Configuration instance for Page Root Provider, a service to fetch the site root page for a given resource.", policy=ConfigurationPolicy.REQUIRE, metatype=true, configurationFactory=true)
@Service(value={PageRootProviderConfig.class})
public class PageRootProviderConfig {
    static final String DEFAULT_PAGE_ROOT_PATH = "/content";
    @Property(label="Root page path pattern", description="Regex(es) used to select the root page root path. Regex must contain at least one group (with index 1) which is used as page root. It is matched against the given path. Evaluates list top-down; first match wins. Defaults to [ /content ]", cardinality=0x7FFFFFFF, value={"/content"})
    static final String PAGE_ROOT_PATH = "page.root.path";
    private static final Logger log = LoggerFactory.getLogger(PageRootProviderConfig.class);
    private List<Pattern> pageRootPatterns = null;

    public List<Pattern> getPageRootPatterns() {
        return this.pageRootPatterns;
    }

    @Activate
    protected void activate(Map<String, Object> props) {
        String[] regexes;
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String regex : regexes = PropertiesUtil.toStringArray((Object)props.get(PAGE_ROOT_PATH), (String[])new String[]{DEFAULT_PAGE_ROOT_PATH})) {
            try {
                Pattern p = Pattern.compile("^(" + regex + ")(|/.*)$");
                patterns.add(p);
                log.debug("Added Page Root Pattern [ {} ] to PageRootProvider", (Object)p);
            }
            catch (Exception e) {
                log.error("Could not compile regex [ {} ] to pattern. Skipping...", (Object)regex, (Object)e);
            }
        }
        this.pageRootPatterns = Collections.unmodifiableList(patterns);
    }

    @Deactivate
    protected void deactivate() {
        if (this.pageRootPatterns != null) {
            for (Pattern p : this.pageRootPatterns) {
                log.debug("Removed Page Root Pattern [ {} ] from PageRootProvider", (Object)p);
            }
            this.pageRootPatterns = null;
        }
    }
}

