/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.exporters.impl.users;

import com.adobe.acs.commons.exporters.impl.users.Parameters;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.Arrays;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;

@SlingServlet(label="ACS AEM Commons - Users to CSV - Init Servlet", methods={"GET"}, resourceTypes={"acs-commons/components/utilities/exporters/users-to-csv"}, selectors={"init"}, extensions={"json"})
public class UsersInitServlet
extends SlingSafeMethodsServlet {
    private static final String QUERY = "SELECT * FROM [rep:Group]  ORDER BY [rep:principalName]";
    private static final String KEY_TEXT = "text";
    private static final String KEY_VALUE = "value";

    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        JsonObject json = new JsonObject();
        JsonObject existing = new JsonObject();
        JsonObject options = new JsonObject();
        try {
            options.add("groups", (JsonElement)this.getGroupOptions(request.getResourceResolver()));
            options.add("groupFilters", (JsonElement)this.getGroupFilterOptions());
            Parameters parameters = new Parameters(request.getResource());
            existing.addProperty("groupFilter", parameters.getGroupFilter());
            existing.add("groups", new Gson().toJsonTree(Arrays.asList(parameters.getGroups())));
            existing.add("customProperties", (JsonElement)parameters.getCustomPropertiesAsJSON());
            json.add("options", (JsonElement)options);
            json.add("form", (JsonElement)existing);
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
        response.getWriter().write(json.toString());
        response.getWriter().flush();
    }

    private JsonArray getGroupOptions(ResourceResolver resourceResolver) throws RepositoryException {
        JsonArray jsonArray = new JsonArray();
        QueryManager queryManager = ((Session)resourceResolver.adaptTo(Session.class)).getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(QUERY, "JCR-SQL2");
        NodeIterator nodeIter = query.execute().getNodes();
        while (nodeIter.hasNext()) {
            Resource resource = resourceResolver.getResource(nodeIter.nextNode().getPath());
            jsonArray.add((JsonElement)new JsonPrimitive((String)resource.getValueMap().get("rep:principalName", (Object)"Unknown")));
        }
        return jsonArray;
    }

    private JsonArray getGroupFilterOptions() {
        JsonObject both = new JsonObject();
        both.addProperty(KEY_TEXT, "Direct or Indirect Membership");
        both.addProperty(KEY_VALUE, "");
        JsonObject direct = new JsonObject();
        direct.addProperty(KEY_TEXT, "Direct Membership");
        direct.addProperty(KEY_VALUE, "direct");
        JsonObject indirect = new JsonObject();
        indirect.addProperty(KEY_TEXT, "Indirect Membership");
        indirect.addProperty(KEY_VALUE, "indirect");
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((JsonElement)direct);
        jsonArray.add((JsonElement)indirect);
        jsonArray.add((JsonElement)both);
        return jsonArray;
    }
}

