/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.asset;

import com.adobe.acs.commons.functions.CheckedConsumer;
import com.adobe.acs.commons.functions.CheckedFunction;
import com.adobe.acs.commons.mcp.impl.processes.asset.NameUtil;
import com.adobe.acs.commons.mcp.impl.processes.asset.Source;
import com.day.cq.commons.jcr.JcrUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public interface HierarchicalElement {
    default public boolean excludeBaseFolder() {
        return false;
    }

    public boolean isFile();

    default public boolean isFolder() {
        return !this.isFile();
    }

    public HierarchicalElement getParent();

    public Stream<HierarchicalElement> getChildren();

    public String getName();

    public String getItemName();

    public String getSourcePath();

    public Source getSource();

    public String getJcrBasePath();

    default public String getNodePath(boolean preserveName) {
        HierarchicalElement parent = this.getParent();
        if (this.excludeBaseFolder()) {
            return parent == null ? this.getJcrBasePath() : parent.getNodePath(preserveName) + "/" + this.getNodeName(preserveName);
        }
        return (parent == null ? this.getJcrBasePath() : parent.getNodePath(preserveName)) + "/" + this.getNodeName(preserveName);
    }

    default public String getNodeName(boolean preserveName) {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        if (preserveName) {
            return this.getNodeName(name);
        }
        if (this.isFile() && name.contains(".")) {
            String baseName = StringUtils.substringBeforeLast((String)name, (String)".");
            String extension = StringUtils.substringAfterLast((String)name, (String)".");
            return NameUtil.createValidDamName(baseName) + "." + NameUtil.createValidDamName(extension);
        }
        return name.matches("(\\w|-)+") ? name : NameUtil.createValidDamName(name);
    }

    default public String getNodeName(String name) {
        if (this.isFile() && name.contains(".")) {
            return name;
        }
        if (JcrUtil.isValidName((String)name)) {
            return name;
        }
        return JcrUtil.createValidName((String)name, (String[])JcrUtil.HYPHEN_LABEL_CHAR_MAPPING, (String)"-");
    }

    default public Stream<HierarchicalElement> getFileChildren() {
        return this.getChildren().filter(HierarchicalElement::isFile);
    }

    default public Stream<HierarchicalElement> getFolderChildren() {
        return this.getChildren().filter(HierarchicalElement::isFolder);
    }

    default public void visitAllFolders(CheckedConsumer<HierarchicalElement> visitor, CheckedFunction<HierarchicalElement, Stream<HierarchicalElement>> childFunction) throws Exception {
        LinkedList<HierarchicalElement> nodes = new LinkedList<HierarchicalElement>();
        nodes.add(this);
        while (!nodes.isEmpty()) {
            HierarchicalElement node = (HierarchicalElement)nodes.pop();
            childFunction.apply(node).forEach(nodes::add);
            visitor.accept(node);
        }
    }

    default public void visitAllFolders(CheckedConsumer<HierarchicalElement> visitor) throws Exception {
        this.visitAllFolders(visitor, HierarchicalElement::getFolderChildren);
    }

    default public void visitAllFiles(CheckedConsumer<HierarchicalElement> visitor, CheckedFunction<HierarchicalElement, Stream<HierarchicalElement>> childFolderFunction, CheckedFunction<HierarchicalElement, Stream<HierarchicalElement>> childFileFunction) throws Exception {
        LinkedList<HierarchicalElement> nodes = new LinkedList<HierarchicalElement>();
        nodes.add(this);
        while (!nodes.isEmpty()) {
            HierarchicalElement node = (HierarchicalElement)nodes.pop();
            childFolderFunction.apply(node).forEach(nodes::add);
            for (HierarchicalElement child : childFileFunction.apply(node).collect(Collectors.toList())) {
                visitor.accept(child);
            }
        }
    }

    default public void visitAllFiles(CheckedConsumer<HierarchicalElement> visitor) throws Exception {
        this.visitAllFiles(visitor, HierarchicalElement::getFolderChildren, HierarchicalElement::getFileChildren);
    }

    public static class UriHelper {
        private static String SFTP_URL_ENCODING = "utf-8";
        private static int FIRST_SUB_PATH_INDEX = 3;

        private UriHelper() {
        }

        static String encodeUriParts(String uri) throws UnsupportedEncodingException {
            Object[] uriParts = uri.split("/");
            for (int i = FIRST_SUB_PATH_INDEX; i < uriParts.length; ++i) {
                uriParts[i] = URLEncoder.encode((String)uriParts[i], SFTP_URL_ENCODING);
            }
            return StringUtils.join((Object[])uriParts, (String)"/");
        }

        static String decodeUriParts(String uri) throws UnsupportedEncodingException {
            return URLDecoder.decode(uri, SFTP_URL_ENCODING);
        }
    }
}

