/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.models.injectors.impl;

import com.adobe.acs.commons.models.injectors.annotation.ChildResourceFromRequest;
import com.adobe.acs.commons.util.OverridePathSlingRequestWrapper;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Injector.class}, property={"service.ranking:Integer=3000"})
public class ChildResourceFromRequestInjector
implements Injector {
    private static final Logger logger = LoggerFactory.getLogger(ChildResourceFromRequestInjector.class);

    public String getName() {
        return "child-resources-from-request";
    }

    public Object getValue(Object adaptable, String name, Type declaredType, AnnotatedElement element, DisposalCallbackRegistry callbackRegistry) {
        if (element.getAnnotation(ChildResourceFromRequest.class) == null) {
            return null;
        }
        if (adaptable instanceof SlingHttpServletRequest) {
            logger.trace("Injecting '{}' from request", (Object)name);
            Class injectionType = null;
            if (declaredType instanceof Class) {
                injectionType = (Class)declaredType;
            } else if (this.isDeclaredTypeCollection(declaredType)) {
                injectionType = this.getActualType((ParameterizedType)declaredType);
            }
            if (injectionType != null) {
                SlingHttpServletRequest request = (SlingHttpServletRequest)adaptable;
                if (Resource.class.isAssignableFrom(injectionType)) {
                    logger.trace("Injected object type is resource, so injecting as resource rather than request");
                    return this.getValueForResource(request.getResource(), name, declaredType);
                }
                return this.getValueForRequest(request, name, declaredType);
            }
        } else if (adaptable instanceof Resource) {
            logger.trace("Injecting '{}' from resource (request not available)", (Object)name);
            return this.getValueForResource((Resource)adaptable, name, declaredType);
        }
        return null;
    }

    private Object getValueForRequest(SlingHttpServletRequest request, String name, Type declaredType) {
        Resource child = request.getResource().getChild(name);
        return this.getValueSingleOrList(child, declaredType, childResource -> new OverridePathSlingRequestWrapper(request, childResource.getPath()));
    }

    private Object getValueForResource(Resource resource, String name, Type declaredType) {
        Resource child = resource.getChild(name);
        return this.getValueSingleOrList(child, declaredType, childResource -> childResource);
    }

    private Object getValueSingleOrList(Resource childAdaptable, Type declaredType, Function<Resource, Object> transformer) {
        if (childAdaptable != null) {
            if (declaredType instanceof Class) {
                return transformer.apply(childAdaptable);
            }
            if (this.isDeclaredTypeCollection(declaredType)) {
                ArrayList<Object> childAdaptables = new ArrayList<Object>();
                Class type = this.getActualType((ParameterizedType)declaredType);
                if (type != null) {
                    Iterator children = childAdaptable.listChildren();
                    while (children.hasNext()) {
                        childAdaptables.add(transformer.apply((Resource)children.next()));
                    }
                }
                return childAdaptables;
            }
        }
        return null;
    }

    private Class getActualType(ParameterizedType declaredType) {
        Type[] types = declaredType.getActualTypeArguments();
        return types != null && types.length > 0 ? (Class)types[0] : null;
    }

    private boolean isDeclaredTypeCollection(Type declaredType) {
        boolean isCollection = false;
        if (declaredType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)declaredType;
            Class collectionType = (Class)type.getRawType();
            isCollection = collectionType.equals(Collection.class) || collectionType.equals(List.class);
        }
        return isCollection;
    }
}

