/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.models.injectors.impl;

import com.adobe.acs.commons.i18n.I18nProvider;
import com.adobe.acs.commons.models.injectors.annotation.I18N;
import com.adobe.acs.commons.models.injectors.impl.InjectorUtils;
import com.adobe.acs.commons.util.impl.ReflectionUtil;
import com.day.cq.i18n.I18n;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=5500"}, service={Injector.class})
public class I18nInjector
implements Injector {
    @Reference
    private I18nProvider i18nProvider;

    public String getName() {
        return "i18n";
    }

    public Object getValue(Object adaptable, String name, Type type, AnnotatedElement annotatedElement, DisposalCallbackRegistry disposal) {
        if (annotatedElement.isAnnotationPresent(I18N.class) && this.canAdaptToString(adaptable, type)) {
            String key = this.getI18nKey(name, annotatedElement);
            if (adaptable instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)adaptable;
                return this.i18nProvider.translate(key, request);
            }
            Resource resource = InjectorUtils.getResource(adaptable);
            return this.i18nProvider.translate(key, resource);
        }
        if (this.canAdaptToObject(adaptable, type)) {
            if (adaptable instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)adaptable;
                return this.i18nProvider.i18n(request);
            }
            Resource resource = InjectorUtils.getResource(adaptable);
            return this.i18nProvider.i18n(resource);
        }
        return null;
    }

    private String getI18nKey(String name, AnnotatedElement annotatedElement) {
        I18N annotation = annotatedElement.getAnnotation(I18N.class);
        String annotationKey = annotation.value();
        if (StringUtils.isNotEmpty((CharSequence)annotationKey)) {
            return annotationKey;
        }
        return name;
    }

    private boolean canAdaptToString(Object adaptable, Type type) {
        return InjectorUtils.getResource(adaptable) != null && ReflectionUtil.isAssignableFrom(type, String.class);
    }

    private boolean canAdaptToObject(Object adaptable, Type type) {
        return InjectorUtils.getResource(adaptable) != null && ReflectionUtil.isAssignableFrom(type, I18n.class);
    }
}

