/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.ondeploy.impl;

import com.adobe.acs.commons.ondeploy.OnDeployExecutor;
import com.adobe.acs.commons.ondeploy.OnDeployScriptProvider;
import com.adobe.acs.commons.ondeploy.impl.OnDeployEarlyTerminationException;
import com.adobe.acs.commons.ondeploy.impl.OnDeployExecutorMBean;
import com.adobe.acs.commons.ondeploy.scripts.OnDeployScript;
import com.adobe.acs.commons.util.RequireAem;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - On-Deploy Scripts Executor", description="Developer tool that triggers scripts (specified via an implementation of OnDeployScriptProvider) to execute on deployment.", metatype=false, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(label="MBean Name", name="jmx.objectname", value={"com.adobe.acs.commons:type=On-Deploy Scripts"}, propertyPrivate=true)})
@Service(value={DynamicMBean.class, OnDeployExecutorMBean.class, OnDeployExecutor.class})
public class OnDeployExecutorImpl
extends AnnotatedStandardMBean
implements OnDeployExecutorMBean,
OnDeployExecutor {
    static final String SCRIPT_STATUS_JCR_FOLDER = "/var/acs-commons/on-deploy-scripts-status";
    private static final String SCRIPT_DATE_END = "endDate";
    private static final String SCRIPT_DATE_START = "startDate";
    private static final String SCRIPT_OUTPUT = "output";
    private static final String SCRIPT_STATUS = "status";
    private static final String SCRIPT_STATUS_FAIL = "fail";
    private static final String SCRIPT_STATUS_RUNNING = "running";
    private static final String SCRIPT_STATUS_SUCCESS = "success";
    private static final String SERVICE_NAME = "on-deploy-scripts";
    private static final Logger logger = LoggerFactory.getLogger(OnDeployExecutorImpl.class);
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference(target="(distribution=classic)")
    RequireAem requireAem;
    @Reference(name="scriptProvider", referenceInterface=OnDeployScriptProvider.class, cardinality=ReferenceCardinality.MANDATORY_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private List<OnDeployScriptProvider> scriptProviders = new CopyOnWriteArrayList<OnDeployScriptProvider>();
    private static transient String[] scriptsItemNames;
    private static transient CompositeType scriptsCompositeType;
    private static transient TabularType scriptsTabularType;

    public OnDeployExecutorImpl() throws NotCompliantMBeanException {
        super(OnDeployExecutorMBean.class);
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void bindScriptProvider(OnDeployScriptProvider scriptProvider) {
        logger.info("Executing on-deploy scripts from scriptProvider: {}", (Object)scriptProvider.getClass().getName());
        this.scriptProviders.add(scriptProvider);
        List<OnDeployScript> scripts = scriptProvider.getScripts();
        if (scripts.size() == 0) {
            logger.debug("No on-deploy scripts found.");
            return;
        }
        try (ResourceResolver resourceResolver = this.logIn();){
            this.runScripts(resourceResolver, scripts);
        }
    }

    protected void unbindScriptProvider(OnDeployScriptProvider scriptProvider) {
        this.scriptProviders.remove(scriptProvider);
    }

    protected Resource getOrCreateStatusTrackingResource(ResourceResolver resourceResolver, Class<?> scriptClass) {
        String scriptClassName = scriptClass.getName();
        Resource resource = resourceResolver.getResource("/var/acs-commons/on-deploy-scripts-status/" + scriptClassName);
        if (resource == null) {
            Resource folder = resourceResolver.getResource(SCRIPT_STATUS_JCR_FOLDER);
            try {
                resource = resourceResolver.create(folder, scriptClassName, Collections.singletonMap("jcr:primaryType", "nt:unstructured"));
            }
            catch (PersistenceException re) {
                logger.error("On-deploy script cannot be run because the system could not find or create the script status node: {}/{}", (Object)SCRIPT_STATUS_JCR_FOLDER, (Object)scriptClassName);
                throw new OnDeployEarlyTerminationException(re);
            }
        }
        return resource;
    }

    protected String getScriptStatus(Resource statusResource) {
        return (String)statusResource.getValueMap().get(SCRIPT_STATUS, (Object)null);
    }

    protected ResourceResolver logIn() {
        try {
            HashMap<String, String> userParams = new HashMap<String, String>();
            userParams.put("sling.service.subservice", SERVICE_NAME);
            return this.resourceResolverFactory.getServiceResourceResolver(userParams);
        }
        catch (LoginException le2) {
            logger.error("On-deploy scripts cannot be run because the system cannot log in with the appropriate service user");
            throw new OnDeployEarlyTerminationException(le2);
        }
    }

    protected boolean runScript(ResourceResolver resourceResolver, OnDeployScript script) {
        Resource statusResource = this.getOrCreateStatusTrackingResource(resourceResolver, script.getClass());
        String status = this.getScriptStatus(statusResource);
        if (status == null || status.equals(SCRIPT_STATUS_FAIL)) {
            this.trackScriptStart(statusResource);
            try {
                script.execute(resourceResolver);
                logger.info("On-deploy script completed successfully: {}", (Object)statusResource.getPath());
                this.trackScriptEnd(statusResource, SCRIPT_STATUS_SUCCESS, "");
                return true;
            }
            catch (Exception e) {
                String errMsg = "On-deploy script failed: " + statusResource.getPath();
                logger.error(errMsg, (Throwable)e);
                resourceResolver.revert();
                this.trackScriptEnd(statusResource, SCRIPT_STATUS_FAIL, ExceptionUtils.getStackTrace((Throwable)e.getCause()));
                throw new OnDeployEarlyTerminationException(new RuntimeException(errMsg));
            }
        }
        if (!status.equals(SCRIPT_STATUS_SUCCESS)) {
            String errMsg = "On-deploy script is already running or in an otherwise unknown state: " + statusResource.getPath() + " - status: " + status;
            logger.error(errMsg);
            throw new OnDeployEarlyTerminationException(new RuntimeException(errMsg));
        }
        logger.debug("Skipping on-deploy script, as it is already complete: {}", (Object)statusResource.getPath());
        return false;
    }

    protected void runScripts(ResourceResolver resourceResolver, List<OnDeployScript> scripts) {
        for (OnDeployScript script : scripts) {
            try {
                this.runScript(resourceResolver, script);
            }
            catch (Exception e) {
                throw new OnDeployEarlyTerminationException(e);
            }
        }
    }

    protected void trackScriptEnd(Resource statusResource, String status, String output) {
        try {
            ModifiableValueMap properties = (ModifiableValueMap)statusResource.adaptTo(ModifiableValueMap.class);
            properties.put((Object)SCRIPT_STATUS, (Object)status);
            properties.put((Object)SCRIPT_DATE_END, (Object)Calendar.getInstance());
            properties.put((Object)SCRIPT_OUTPUT, (Object)output);
            statusResource.getResourceResolver().commit();
        }
        catch (PersistenceException e) {
            logger.error("On-deploy script status node could not be updated: {} - status: {}", (Object)statusResource.getPath(), (Object)status);
            throw new OnDeployEarlyTerminationException(e);
        }
    }

    protected void trackScriptStart(Resource statusResource) {
        logger.info("Starting on-deploy script: {}", (Object)statusResource.getPath());
        try {
            ModifiableValueMap properties = (ModifiableValueMap)statusResource.adaptTo(ModifiableValueMap.class);
            properties.put((Object)SCRIPT_STATUS, (Object)SCRIPT_STATUS_RUNNING);
            properties.put((Object)SCRIPT_DATE_START, (Object)Calendar.getInstance());
            properties.remove((Object)SCRIPT_DATE_END);
            properties.remove((Object)SCRIPT_OUTPUT);
            statusResource.getResourceResolver().commit();
        }
        catch (PersistenceException e) {
            logger.error("On-deploy script cannot be run because the system could not write to the script status node: {}", (Object)statusResource.getPath());
            throw new OnDeployEarlyTerminationException(e);
        }
    }

    @Override
    public TabularDataSupport getScripts() throws OpenDataException {
        TabularDataSupport scriptStatus = new TabularDataSupport(OnDeployExecutorImpl.getScriptsTableType());
        try (ResourceResolver resourceResolver = this.logIn();){
            if (this.scriptProviders != null) {
                for (OnDeployScriptProvider provider : this.scriptProviders) {
                    List<OnDeployScript> scripts = provider.getScripts();
                    for (OnDeployScript script : scripts) {
                        Resource trackingResource = this.getOrCreateStatusTrackingResource(resourceResolver, script.getClass());
                        ValueMap scriptStatusProps = (ValueMap)trackingResource.adaptTo(ValueMap.class);
                        Date startDate = (Date)scriptStatusProps.get(SCRIPT_DATE_START, Date.class);
                        Date endDate = (Date)scriptStatusProps.get(SCRIPT_DATE_END, Date.class);
                        String status = (String)scriptStatusProps.get(SCRIPT_STATUS, (Object)"");
                        CompositeDataSupport scriptStatusData = new CompositeDataSupport(scriptsCompositeType, scriptsItemNames, new Object[]{provider.getClass().getCanonicalName(), script.getClass().getCanonicalName(), startDate, endDate, status});
                        scriptStatus.put(scriptStatusData);
                    }
                }
            }
        }
        return scriptStatus;
    }

    @Override
    public boolean executeScript(String scriptName, boolean force) {
        AtomicBoolean executed = new AtomicBoolean(false);
        try (ResourceResolver resourceResolver = this.logIn();){
            this.scriptProviders.stream().map(OnDeployScriptProvider::getScripts).flatMap(Collection::stream).filter(s -> s.getClass().getCanonicalName().equals(scriptName)).findFirst().ifPresent(script -> {
                if (force) {
                    logger.info("resetting the status of script {}", (Object)script.getClass().getCanonicalName());
                    Resource trackingRes = this.getOrCreateStatusTrackingResource(resourceResolver, script.getClass());
                    try {
                        resourceResolver.delete(trackingRes);
                        resourceResolver.commit();
                    }
                    catch (PersistenceException e) {
                        logger.error("failed while resetting script status.", (Throwable)e);
                    }
                }
                executed.set(this.runScript(resourceResolver, (OnDeployScript)script));
            });
        }
        return executed.get();
    }

    private static TabularType getScriptsTableType() {
        return scriptsTabularType;
    }

    static {
        try {
            scriptsItemNames = new String[]{"_provider", "_script", SCRIPT_DATE_START, SCRIPT_DATE_END, SCRIPT_STATUS};
            scriptsCompositeType = new CompositeType("Script Row", "single script status row", scriptsItemNames, new String[]{"Provider", "Script", "Start Date", "End Date", "Status"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.DATE, SimpleType.DATE, SimpleType.STRING});
            scriptsTabularType = new TabularType("Scripts", "On-Deploy Scripts", scriptsCompositeType, new String[]{"_provider", "_script"});
        }
        catch (OpenDataException ex) {
            logger.error("Unable to build MBean composite types", (Throwable)ex);
        }
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindRequireAem(RequireAem requireAem) {
        this.requireAem = requireAem;
    }

    protected void unbindRequireAem(RequireAem requireAem) {
        if (this.requireAem == requireAem) {
            this.requireAem = null;
        }
    }
}

