/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.internal;

import com.adobe.acs.commons.reports.api.ReportCellCSVExporter;
import com.adobe.acs.commons.reports.api.ReportException;
import com.adobe.acs.commons.reports.api.ReportExecutor;
import com.adobe.acs.commons.reports.api.ResultsPage;
import com.adobe.acs.commons.reports.internal.ReportExecutorProvider;
import com.day.text.csv.Csv;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=acs-commons/components/utilities/report-builder/report-page", "sling.servlet.selectors=report", "sling.servlet.extensions=csv", "sling.servlet.methods=GET"})
public class ReportCSVExportServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 2794836639686938093L;
    private static final Logger log = LoggerFactory.getLogger(ReportCSVExportServlet.class);
    @Reference
    private transient DynamicClassLoaderManager dynamicClassLoaderManager;

    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        block8: {
            log.trace("doGet");
            response.setContentType("text/csv");
            response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode((String)request.getResource().getValueMap().get("jcr:title", (Object)"report"), "UTF-8") + ".csv");
            PrintWriter writer = null;
            try {
                writer = response.getWriter();
                Csv csv = new Csv();
                csv.writeInit((Writer)writer);
                List<ReportCellCSVExporter> exporters = this.writeHeaders(request, csv);
                Resource configCtr = request.getResource().getChild("config");
                if (configCtr != null && configCtr.listChildren().hasNext()) {
                    Iterator children = configCtr.listChildren();
                    while (children.hasNext()) {
                        Resource config = (Resource)children.next();
                        if (config != null) {
                            this.updateCSV(config, request, exporters, csv, writer);
                            log.debug("Successfully export report with configuration: {}", (Object)config);
                            break;
                        }
                        log.warn("Unable to export report for configuration: {}", (Object)config);
                    }
                    csv.close();
                    break block8;
                }
                throw new IOException("No configurations found for " + request.getResource());
            }
            catch (ReportException e) {
                throw new ServletException("Exception extracting report to CSV", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }

    private List<ReportCellCSVExporter> writeHeaders(SlingHttpServletRequest request, Csv csv) throws IOException {
        ArrayList<Object> row = new ArrayList<Object>();
        ArrayList<ReportCellCSVExporter> exporters = new ArrayList<ReportCellCSVExporter>();
        for (Resource column : request.getResource().getChild("columns").getChildren()) {
            String className = (String)column.getValueMap().get("exporter", String.class);
            if (StringUtils.isEmpty((CharSequence)className)) continue;
            try {
                log.debug("Finding ReportCellCSVExporter for {}", (Object)className);
                Class<?> clazz = Class.forName(className, true, this.dynamicClassLoaderManager.getDynamicClassLoader());
                ReportCellCSVExporter exporter = (ReportCellCSVExporter)column.adaptTo(clazz);
                log.debug("Loaded ReportCellCSVExporter {}", (Object)exporter);
                if (exporter != null) {
                    exporters.add(exporter);
                    row.add(column.getValueMap().get("heading", String.class));
                    continue;
                }
                log.warn("Retrieved null ReportCellCSVExporter for {}", (Object)className);
            }
            catch (Exception e) {
                log.warn("Unable to render column due to issue fetching ReportCellCSVExporter " + className, (Throwable)e);
            }
        }
        csv.writeRow(row.toArray(new String[row.size()]));
        return exporters;
    }

    private void updateCSV(Resource config, SlingHttpServletRequest request, List<ReportCellCSVExporter> exporters, Csv csv, Writer writer) throws ReportException {
        Class<?> executorClass = ReportExecutorProvider.INSTANCE.getReportExecutor(this.dynamicClassLoaderManager, config);
        ReportExecutor executor = Optional.ofNullable(request.adaptTo(executorClass)).filter(model -> model instanceof ReportExecutor).map(model -> (ReportExecutor)model).orElseThrow(() -> new ReportException("Failed to get report executor"));
        executor.setConfiguration(config);
        log.debug("Retrieved executor {}", (Object)executor);
        ResultsPage queryResult = executor.getAllResults();
        List<Object> results = queryResult.getResults();
        log.debug("Retrieved {} results", (Object)results.size());
        for (Object result : results) {
            ArrayList<String> row = new ArrayList<String>();
            try {
                for (ReportCellCSVExporter exporter : exporters) {
                    row.add(exporter.getValue(result));
                }
                csv.writeRow(row.toArray(new String[row.size()]));
                writer.flush();
            }
            catch (Exception e) {
                log.warn("Exception writing row: " + row, (Throwable)e);
            }
        }
        log.debug("Results written successfully");
    }
}

