/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.datasources.impl;

import com.adobe.acs.commons.wcm.datasources.DataSourceBuilder;
import com.adobe.acs.commons.wcm.datasources.DataSourceOption;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

@Component
@Service
public class DataSourceBuilderImpl
implements DataSourceBuilder {
    @Override
    public void addDataSource(SlingHttpServletRequest slingRequest, List<DataSourceOption> options) {
        ArrayList<ValueMapResource> resourceList = new ArrayList<ValueMapResource>();
        Object dataSource = null;
        for (DataSourceOption option : options) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("text", option.getText());
            map.put("value", option.getValue());
            resourceList.add(new ValueMapResource(slingRequest.getResourceResolver(), new ResourceMetadata(), "", (ValueMap)new ValueMapDecorator(map)));
        }
        dataSource = resourceList.size() > 0 ? new SimpleDataSource(resourceList.iterator()) : EmptyDataSource.instance();
        slingRequest.setAttribute(DataSource.class.getName(), dataSource);
    }

    @Override
    public void writeDataSourceOptions(SlingHttpServletRequest slingRequest, SlingHttpServletResponse slingResponse) throws IOException {
        Iterator iterator;
        DataSource datasource = (DataSource)slingRequest.getAttribute(DataSource.class.getName());
        JsonArray jsonArray = new JsonArray();
        if (datasource != null && (iterator = datasource.iterator()) != null) {
            while (iterator.hasNext()) {
                ValueMap dataProps;
                Resource dataResource = (Resource)iterator.next();
                if (dataResource == null || (dataProps = (ValueMap)dataResource.adaptTo(ValueMap.class)) == null) continue;
                JsonObject json = new JsonObject();
                json.addProperty("text", (String)dataProps.get("text", (Object)""));
                json.addProperty("value", (String)dataProps.get("value", (Object)""));
                jsonArray.add((JsonElement)json);
            }
        }
        slingResponse.setContentType("application/json; charset=UTF-8");
        slingResponse.setCharacterEncoding("UTF-8");
        Gson gson = new Gson();
        gson.toJson((JsonElement)jsonArray, (Appendable)slingResponse.getWriter());
    }
}

