/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.adobe.acs.commons.util.BufferedHttpServletResponse;
import com.adobe.acs.commons.util.BufferedServletOutput;
import com.day.cq.wcm.api.WCMMode;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.xss.XSSAPI;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - AEM Environment Indicator", description="Adds a visual cue to the AEM WebUI indicating which environment is being access (localdev, dev, qa, staging)", metatype=true)
public class AemEnvironmentIndicatorFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AemEnvironmentIndicatorFilter.class);
    private static final String DIV_ID = "acs-commons-env-indicator";
    private static final String BASE_DEFAULT_STYLE = ";background-image:url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA3NpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNS1jMDIxIDc5LjE1NDkxMSwgMjAxMy8xMC8yOS0xMTo0NzoxNiAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDo5ZmViMDk1Ni00MTMwLTQ0NGMtYWM3Ny02MjU0NjY0OTczZWIiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6MDk4RTBGQkYzMjA5MTFFNDg5MDFGQzVCQkEyMjY0NDQiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6MDk4RTBGQkUzMjA5MTFFNDg5MDFGQzVCQkEyMjY0NDQiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIChNYWNpbnRvc2gpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6Mjc5NmRkZmItZDVlYi00N2RlLWI1NDMtNDgxNzU2ZjIwZDc1IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOjlmZWIwOTU2LTQxMzAtNDQ0Yy1hYzc3LTYyNTQ2NjQ5NzNlYiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Ps64/vsAAAAkSURBVHjaYvz//z8DGjBmAAkiYWOwInQBZEFjZB0YAiAMEGAAVBk/wkPTSYQAAAAASUVORK5CYII=');border-bottom: 1px solid rgba(0, 0, 0, .25);box-sizing: border-box;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;position: fixed;left: 0;top: 0;right: 0;height: 5px;z-index: 100000000000000;";
    private static final String TITLE_UPDATE_SCRIPT = "<script>(function() { var c = 0; t = '%s' + ' | ' + document.title, i = setInterval(function() { if (document.title === t && c++ > 10) { clearInterval(i); } else { document.title = t; } }, 1500); document.title = t; })();</script>\n";
    @Reference
    private XSSAPI xss;
    private String color = "";
    @Property(label="Color", description="The color of the indicator bar; takes any valid value for CSS's 'background-color' attribute. This is ignored if a Style Override is provided.", value={""})
    public static final String PROP_COLOR = "css-color";
    private String cssOverride = "";
    @Property(label="CSS Override", description="Accepts any valid CSS to style the AEM indicator div. All CSS rules must only be scoped to #acs-commons-env-indicator { .. }", value={""})
    public static final String PROP_CSS_OVERRIDE = "css-override";
    private String innerHTML = "";
    @Property(label="Inner HTML", description="Any additional HTML required; Will be injected into a div with id='acs-commons-env-indicator'", value={""})
    public static final String PROP_INNER_HTML = "inner-html";
    private static final String DEFAULT_TITLE_PREFIX = "";
    private String titlePrefix = "";
    private boolean alwaysIncludeBaseCss;
    @Property(label="Always Include Base CSS", description="Always include the base CSS scoped to #acs-commons-env-indicator { .. }", boolValue={false})
    public static final String PROP_ALWAYS_INCLUDE_BASE_CSS = "always-include-base-css";
    private boolean alwaysIncludeColorCss;
    @Property(label="Always Include Color CSS", description="Always include the color CSS scoped to #acs-commons-env-indicator { .. }", boolValue={false})
    public static final String PROP_ALWAYS_INCLUDE_COLOR_CSS = "always-include-color-css";
    @Property(label="Browser Title", description="A prefix to add to the browser tab/window title; <THIS VALUE> | <ORIGINAL DOC TITLE>", value={""})
    public static final String PROP_TITLE_PREFIX = "browser-title-prefix";
    private static final String[] DEFAULT_EXCLUDED_WCMMODES = new String[]{"DISABLED"};
    @Property(label="Excluded WCM modes", description="Do not display the indicator when these WCM modes", cardinality=0x7FFFFFFF)
    public static final String PROP_EXCLUDED_WCMMODES = "excluded-wcm-modes";
    private String[] excludedWCMModes;
    private String css = "";
    private ServiceRegistration filterRegistration;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.accepts(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try (BufferedHttpServletResponse capturedResponse = new BufferedHttpServletResponse(response, new StringWriter(), null);){
            String contents;
            log.debug("Executing the rest of the filter chain");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)capturedResponse);
            log.debug("Executing the rest of the filter chain");
            String string = contents = capturedResponse.getBufferedServletOutput().getWriteMethod() == BufferedServletOutput.ResponseWriteMethod.WRITER ? capturedResponse.getBufferedServletOutput().getBufferedString() : null;
            if (contents != null && StringUtils.contains((CharSequence)response.getContentType(), (CharSequence)"html")) {
                int bodyIndex = contents.indexOf("</body>");
                if (bodyIndex != -1) {
                    capturedResponse.resetBuffer();
                    PrintWriter printWriter = response.getWriter();
                    printWriter.write(contents.substring(0, bodyIndex));
                    this.writeEnvironmentIndicator(this.css, this.innerHTML, this.titlePrefix, printWriter);
                    printWriter.write(contents.substring(bodyIndex));
                }
            } else if (contents != null) {
                response.setContentLength(contents.length());
                PrintWriter printWriter = response.getWriter();
                printWriter.write(contents);
            }
        }
    }

    void writeEnvironmentIndicator(String css, String innerHTML, String titlePrefix, PrintWriter printWriter) {
        if (StringUtils.isNotBlank((CharSequence)css)) {
            printWriter.write("<style>" + css + " </style>");
            printWriter.write("<div id=\"acs-commons-env-indicator\">" + innerHTML + "</div>");
        }
        if (StringUtils.isNotBlank((CharSequence)titlePrefix)) {
            printWriter.printf(TITLE_UPDATE_SCRIPT, titlePrefix);
        }
    }

    public void destroy() {
    }

    boolean accepts(HttpServletRequest request) {
        if (this.isImproperlyConfigured(this.css, this.titlePrefix)) {
            log.warn("AEM Environment Indicator is not properly configured; If this feature is unwanted, remove the OSGi configuration and disable completely.");
            return false;
        }
        if (this.isUnsupportedRequestMethod(request.getMethod())) {
            log.debug("Request was not a GET request");
            return false;
        }
        if (this.isXhr(request.getHeader("X-Requested-With"))) {
            log.debug("Request was an XHR");
            return false;
        }
        if (this.hasAemEditorReferrer(request.getHeader("Referer"), request.getRequestURI())) {
            log.debug("Request was for a page in an editor");
            return false;
        }
        if (this.isDisallowedWcmMode(this.getWcmMode(request), this.excludedWCMModes)) {
            log.debug("WCMMode was a disallowed mode");
            return false;
        }
        log.debug("All checks pass, filter can execute");
        return true;
    }

    boolean isImproperlyConfigured(String css, String titlePrefix) {
        return StringUtils.isBlank((CharSequence)css) && StringUtils.isBlank((CharSequence)titlePrefix);
    }

    boolean isUnsupportedRequestMethod(String requestMethod) {
        return !StringUtils.equalsIgnoreCase((CharSequence)"get", (CharSequence)requestMethod);
    }

    boolean isXhr(String headerValue) {
        return StringUtils.equals((CharSequence)headerValue, (CharSequence)"XMLHttpRequest");
    }

    boolean hasAemEditorReferrer(String headerValue, String requestUri) {
        return StringUtils.endsWith((CharSequence)headerValue, (CharSequence)("/editor.html" + requestUri)) || StringUtils.endsWith((CharSequence)headerValue, (CharSequence)"/cf");
    }

    boolean isDisallowedWcmMode(WCMMode currentMode, String[] excludedWcmModes) {
        return currentMode == null || StringUtils.equalsAnyIgnoreCase((CharSequence)currentMode.name(), (CharSequence[])excludedWcmModes);
    }

    @Activate
    protected final void activate(ComponentContext ctx) {
        Dictionary config = ctx.getProperties();
        this.color = PropertiesUtil.toString(config.get(PROP_COLOR), (String)DEFAULT_TITLE_PREFIX);
        this.cssOverride = PropertiesUtil.toString(config.get(PROP_CSS_OVERRIDE), (String)DEFAULT_TITLE_PREFIX);
        this.innerHTML = PropertiesUtil.toString(config.get(PROP_INNER_HTML), (String)DEFAULT_TITLE_PREFIX);
        this.innerHTML = new StrSubstitutor(StrLookup.systemPropertiesLookup()).replace(this.innerHTML);
        this.alwaysIncludeBaseCss = PropertiesUtil.toBoolean((Object)PROP_ALWAYS_INCLUDE_BASE_CSS, (boolean)false);
        this.alwaysIncludeColorCss = PropertiesUtil.toBoolean((Object)PROP_ALWAYS_INCLUDE_COLOR_CSS, (boolean)false);
        this.alwaysIncludeBaseCss = PropertiesUtil.toBoolean((Object)PROP_ALWAYS_INCLUDE_BASE_CSS, (boolean)false);
        this.alwaysIncludeColorCss = PropertiesUtil.toBoolean((Object)PROP_ALWAYS_INCLUDE_COLOR_CSS, (boolean)false);
        StringBuilder cssSb = new StringBuilder();
        if (this.shouldUseBaseCss(this.alwaysIncludeBaseCss, this.cssOverride, this.color)) {
            cssSb.append(this.createBaseCss());
        }
        if (this.shouldUseColorCss(this.alwaysIncludeColorCss, this.cssOverride, this.color)) {
            cssSb.append(this.createColorCss(this.color));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cssOverride)) {
            cssSb.append(this.cssOverride);
        }
        this.css = cssSb.toString();
        this.titlePrefix = this.xss.encodeForJSString(PropertiesUtil.toString(config.get(PROP_TITLE_PREFIX), (String)DEFAULT_TITLE_PREFIX).toString());
        if (StringUtils.isNotBlank((CharSequence)this.css) || StringUtils.isNotBlank((CharSequence)this.titlePrefix)) {
            Hashtable<String, String> filterProps = new Hashtable<String, String>();
            ((Dictionary)filterProps).put("osgi.http.whiteboard.filter.pattern", "/");
            ((Dictionary)filterProps).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=*)");
            this.filterRegistration = ctx.getBundleContext().registerService(Filter.class.getName(), (Object)this, filterProps);
        }
        this.excludedWCMModes = PropertiesUtil.toStringArray(config.get(PROP_EXCLUDED_WCMMODES), (String[])DEFAULT_EXCLUDED_WCMMODES);
    }

    String createBaseCss() {
        return "#acs-commons-env-indicator { ;background-image:url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA3NpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNS1jMDIxIDc5LjE1NDkxMSwgMjAxMy8xMC8yOS0xMTo0NzoxNiAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDo5ZmViMDk1Ni00MTMwLTQ0NGMtYWM3Ny02MjU0NjY0OTczZWIiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6MDk4RTBGQkYzMjA5MTFFNDg5MDFGQzVCQkEyMjY0NDQiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6MDk4RTBGQkUzMjA5MTFFNDg5MDFGQzVCQkEyMjY0NDQiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIChNYWNpbnRvc2gpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6Mjc5NmRkZmItZDVlYi00N2RlLWI1NDMtNDgxNzU2ZjIwZDc1IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOjlmZWIwOTU2LTQxMzAtNDQ0Yy1hYzc3LTYyNTQ2NjQ5NzNlYiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Ps64/vsAAAAkSURBVHjaYvz//z8DGjBmAAkiYWOwInQBZEFjZB0YAiAMEGAAVBk/wkPTSYQAAAAASUVORK5CYII=');border-bottom: 1px solid rgba(0, 0, 0, .25);box-sizing: border-box;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;position: fixed;left: 0;top: 0;right: 0;height: 5px;z-index: 100000000000000; }";
    }

    String createColorCss(String providedColor) {
        return "#acs-commons-env-indicator { background-color:" + providedColor + "; }";
    }

    boolean shouldUseBaseCss(boolean alwaysInclude, String cssOverride, String color) {
        return alwaysInclude || StringUtils.isBlank((CharSequence)cssOverride) && StringUtils.isNotBlank((CharSequence)color);
    }

    boolean shouldUseColorCss(boolean alwaysInclude, String cssOverride, String color) {
        return alwaysInclude || StringUtils.isBlank((CharSequence)cssOverride) && StringUtils.isNotBlank((CharSequence)color);
    }

    @Deactivate
    protected final void deactivate(Map<String, String> config) {
        if (this.filterRegistration != null) {
            this.filterRegistration.unregister();
            this.filterRegistration = null;
        }
        this.css = DEFAULT_TITLE_PREFIX;
    }

    WCMMode getWcmMode(HttpServletRequest request) {
        return WCMMode.fromRequest((ServletRequest)request);
    }

    String getCss() {
        return this.css;
    }

    String getTitlePrefix() {
        return this.titlePrefix;
    }

    String[] getExcludedWCMModes() {
        return this.excludedWCMModes;
    }

    protected void bindXss(XSSAPI xSSAPI) {
        this.xss = xSSAPI;
    }

    protected void unbindXss(XSSAPI xSSAPI) {
        if (this.xss == xSSAPI) {
            this.xss = null;
        }
    }
}

