/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.CompositeValueMap;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.servlets.post.AbstractPostResponse;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE, immediate=true)
@Properties(value={@Property(name="service.ranking", intValue={-2000}), @Property(name="sling.filter.scope", value={"REQUEST"}), @Property(name="sling.filter.pattern", value={"/content/dam/.*"}), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="sling.servlet.resourceTypes", value={"acs-commons/touchui-widgets/asset-folder-properties-support"})})
@Service
public class AssetsFolderPropertiesSupport
extends SlingSafeMethodsServlet
implements Filter,
SlingPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(AssetsFolderPropertiesSupport.class);
    private static final String DAM_PATH_PREFIX = "/content/dam";
    private static final String POST_METHOD = "post";
    private static final String OPERATION = ":operation";
    private static final String DAM_FOLDER_SHARE_OPERATION = "dam.share.folder";
    private static final String GRANITE_UI_FORM_VALUES = "granite.ui.form.values";
    @Reference(target="&(sling.post.operation=dam.share.folder)(sling.servlet.methods=POST)")
    private transient PostOperation folderShareHandler;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest request = (SlingHttpServletRequest)servletRequest;
        SlingHttpServletResponse response = (SlingHttpServletResponse)servletResponse;
        if (!this.accepts(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        log.trace("ACS AEM Commons Assets Folder Properties Support applied to POST Request");
        chain.doFilter((ServletRequest)new AssetsFolderPropertiesSupportRequest(request, null), (ServletResponse)response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        if (AssetsFolderPropertiesSupportRequest.isMarked(request)) {
            log.trace("Sending the the wrapped dam.folder.share request to the AEM Assets dam.folder.share PostOperation for final processing");
            AssetsFolderPropertiesSupportRequest wrappedRequest = new AssetsFolderPropertiesSupportRequest(request, DAM_FOLDER_SHARE_OPERATION);
            this.folderShareHandler.run((SlingHttpServletRequest)wrappedRequest, (PostResponse)new DummyPostResponse(), new SlingPostProcessor[0]);
            log.trace("Processed the the wrapped dam.folder.share request with the AEM Assets dam.folder.share PostOperation");
        }
    }

    protected boolean accepts(SlingHttpServletRequest request) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)POST_METHOD, (CharSequence)request.getMethod())) {
            return false;
        }
        if (!DAM_FOLDER_SHARE_OPERATION.equals(request.getParameter(OPERATION))) {
            return false;
        }
        if (!StringUtils.startsWith((CharSequence)request.getResource().getPath(), (CharSequence)DAM_PATH_PREFIX)) {
            return false;
        }
        return request.getResource().isResourceType("sling:Folder") || request.getResource().isResourceType("sling:OrderedFolder");
    }

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource suffixResource = request.getResourceResolver().resolve(request.getRequestPathInfo().getSuffix());
        if (suffixResource == null) {
            return;
        }
        log.trace("AssetsFolderPropertiesSupport GET method for folder resource [ {} ]", (Object)suffixResource.getPath());
        ValueMap formProperties = (ValueMap)request.getAttribute(GRANITE_UI_FORM_VALUES);
        if (formProperties == null) {
            formProperties = new ValueMapDecorator(new HashMap());
        }
        request.setAttribute(GRANITE_UI_FORM_VALUES, (Object)new CompositeValueMap(formProperties, suffixResource.getValueMap(), true));
    }

    protected void bindFolderShareHandler(PostOperation postOperation) {
        this.folderShareHandler = postOperation;
    }

    protected void unbindFolderShareHandler(PostOperation postOperation) {
        if (this.folderShareHandler == postOperation) {
            this.folderShareHandler = null;
        }
    }

    protected static class AssetsFolderPropertiesSupportRequest
    extends SlingHttpServletRequestWrapper {
        private static String REQUEST_ATTR_KEY = AssetsFolderPropertiesSupportRequest.class.getName();
        private String operationValue;

        public AssetsFolderPropertiesSupportRequest(SlingHttpServletRequest request, String operationValue) {
            super(request);
            AssetsFolderPropertiesSupportRequest.markRequest(request);
            this.operationValue = operationValue;
        }

        public static void markRequest(SlingHttpServletRequest request) {
            request.setAttribute(REQUEST_ATTR_KEY, (Object)true);
        }

        protected static boolean isMarked(SlingHttpServletRequest request) {
            return request.getAttribute(REQUEST_ATTR_KEY) != null;
        }

        public String getParameter(String key) {
            if (AssetsFolderPropertiesSupportRequest.isMarked((SlingHttpServletRequest)this) && AssetsFolderPropertiesSupport.OPERATION.equals(key)) {
                return this.operationValue;
            }
            return super.getParameter(key);
        }
    }

    protected class DummyPostResponse
    extends AbstractPostResponse {
        protected DummyPostResponse() {
        }

        protected void doSend(HttpServletResponse response) throws IOException {
        }

        public void onChange(String type, String ... arguments) {
        }
    }
}

