/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import com.adobe.acs.commons.redirects.filter.RedirectFilter;
import com.adobe.acs.commons.redirects.models.RedirectMatch;
import com.adobe.acs.commons.redirects.models.RedirectRule;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.Resource;

public class RedirectConfiguration {
    private Map<String, RedirectRule> pathRules = new LinkedHashMap<String, RedirectRule>();
    private Map<Pattern, RedirectRule> patternRules = new LinkedHashMap<Pattern, RedirectRule>();
    private String path;
    private String name;
    public static final RedirectConfiguration EMPTY = new RedirectConfiguration();

    private RedirectConfiguration() {
    }

    public RedirectConfiguration(Resource resource, String storageSuffix) {
        this.path = resource.getPath();
        this.name = this.path.replace("/" + storageSuffix, "");
        Collection<RedirectRule> rules = RedirectFilter.getRules(resource);
        for (RedirectRule rule : rules) {
            if (rule.getRegex() != null) {
                this.patternRules.put(rule.getRegex(), rule);
                continue;
            }
            this.pathRules.put(RedirectConfiguration.normalizePath(rule.getSource()), rule);
        }
    }

    public static String normalizePath(String resourcePath) {
        int sep = resourcePath.lastIndexOf(46);
        if (sep != -1 && !resourcePath.startsWith("/content/dam/")) {
            resourcePath = resourcePath.substring(0, sep);
        }
        return resourcePath;
    }

    public Map<String, RedirectRule> getPathRules() {
        return this.pathRules;
    }

    public Map<Pattern, RedirectRule> getPatternRules() {
        return this.patternRules;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public RedirectMatch match(String requestPath) {
        return this.match(requestPath, "");
    }

    public RedirectMatch match(String requestPath, String contextPrefix) {
        String normalizedPath = RedirectConfiguration.normalizePath(requestPath);
        RedirectMatch match = null;
        RedirectRule rule = this.getPathRule(normalizedPath, contextPrefix);
        if (rule != null) {
            match = new RedirectMatch(rule, null);
        } else {
            for (Map.Entry<Pattern, RedirectRule> entry : this.getPatternRules().entrySet()) {
                Matcher m = this.getRuleMatch(entry.getKey(), normalizedPath, contextPrefix);
                if (!m.matches()) continue;
                match = new RedirectMatch(entry.getValue(), m);
                break;
            }
        }
        return match;
    }

    private Matcher getRuleMatch(Pattern rulePattern, String normalizedPath, String contextPrefix) {
        Matcher matcher;
        if ("".equals(contextPrefix)) {
            return rulePattern.matcher(normalizedPath);
        }
        if (!rulePattern.toString().startsWith(contextPrefix)) {
            rulePattern = RedirectRule.toRegex(contextPrefix + rulePattern.toString());
        }
        if (!(matcher = rulePattern.matcher(normalizedPath)).matches()) {
            matcher = normalizedPath.startsWith(contextPrefix) ? rulePattern.matcher(normalizedPath.replace(contextPrefix, "")) : rulePattern.matcher(contextPrefix + normalizedPath);
        }
        return matcher;
    }

    private RedirectRule getPathRule(String normalizedPath, String contextPrefix) {
        if ("".equals(contextPrefix)) {
            return this.getPathRules().get(normalizedPath);
        }
        RedirectRule rule = this.getPathRules().get(normalizedPath);
        if (rule == null) {
            rule = normalizedPath.startsWith(contextPrefix) ? this.getPathRules().get(normalizedPath.replace(contextPrefix, "")) : this.getPathRules().get(contextPrefix + normalizedPath);
        }
        return rule;
    }
}

