/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import com.adobe.acs.commons.redirects.models.SubstitutionElement;
import java.lang.invoke.MethodHandles;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class RedirectRule {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SOURCE_PROPERTY_NAME = "source";
    public static final String TARGET_PROPERTY_NAME = "target";
    public static final String STATUS_CODE_PROPERTY_NAME = "statusCode";
    public static final String UNTIL_DATE_PROPERTY_NAME = "untilDate";
    public static final String NOTE_PROPERTY_NAME = "note";
    public static final String CONTEXT_PREFIX_IGNORED = "contextPrefixIgnored";
    @Inject
    private String source;
    @Inject
    private String target;
    @Inject
    private int statusCode;
    @Inject
    private String note;
    @Inject
    private boolean contextPrefixIgnored;
    private ZonedDateTime untilDate;
    private Pattern ptrn;
    private SubstitutionElement[] substitutions;

    public RedirectRule(String source, String target, int statusCode, Calendar calendar, String note) {
        this(source, target, statusCode, calendar, note, false);
    }

    public RedirectRule(String source, String target, int statusCode, Calendar calendar, String note, boolean contextPrefixIgnored) {
        this.source = source.trim();
        this.target = target.trim();
        this.statusCode = statusCode;
        this.note = note;
        this.contextPrefixIgnored = contextPrefixIgnored;
        String regex = this.source;
        if (regex.endsWith("*")) {
            regex = regex.replaceAll("\\*$", "(.*)");
        }
        this.ptrn = RedirectRule.toRegex(regex);
        this.substitutions = SubstitutionElement.parse(this.target);
        if (calendar != null) {
            this.untilDate = ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
    }

    public static RedirectRule from(ValueMap resource) {
        Object o;
        String source = (String)resource.get(SOURCE_PROPERTY_NAME, (Object)"");
        String target = (String)resource.get(TARGET_PROPERTY_NAME, (Object)"");
        String note = (String)resource.get(NOTE_PROPERTY_NAME, (Object)"");
        int statusCode = (Integer)resource.get(STATUS_CODE_PROPERTY_NAME, (Object)0);
        boolean contextPrefixIgnored = (Boolean)resource.get(CONTEXT_PREFIX_IGNORED, (Object)false);
        Calendar calendar = null;
        if (resource.containsKey((Object)UNTIL_DATE_PROPERTY_NAME) && (o = resource.get((Object)UNTIL_DATE_PROPERTY_NAME)) instanceof Calendar) {
            calendar = (Calendar)o;
        }
        return new RedirectRule(source, target, statusCode, calendar, note, contextPrefixIgnored);
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public String getNote() {
        return this.note;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean getContextPrefixIgnored() {
        return this.contextPrefixIgnored;
    }

    public Pattern getRegex() {
        return this.ptrn;
    }

    public ZonedDateTime getUntilDate() {
        return this.untilDate;
    }

    public String toString() {
        return String.format("RedirectRule{source='%s', target='%s', statusCode=%s, untilDate=%s, note=%s, contextPrefixIgnored=%s}", this.source, this.target, this.statusCode, this.untilDate, this.note, this.contextPrefixIgnored);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedirectRule that = (RedirectRule)o;
        return Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return this.source != null ? this.source.hashCode() : 0;
    }

    public String evaluate(Matcher matcher) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.substitutions.length; ++i) {
            buf.append(this.substitutions[i].evaluate(matcher));
        }
        return buf.toString();
    }

    static Pattern toRegex(String src) {
        Pattern ptrn;
        try {
            ptrn = Pattern.compile(src);
            int groupCount = ptrn.matcher("").groupCount();
            if (groupCount == 0) {
                ptrn = null;
            }
        }
        catch (PatternSyntaxException e) {
            log.info("invalid regex: {}", (Object)src);
            ptrn = null;
        }
        return ptrn;
    }
}

