/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.servlets;

import com.adobe.acs.commons.redirects.filter.RedirectFilter;
import com.adobe.acs.commons.redirects.models.RedirectRule;
import java.io.IOException;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import javax.servlet.Servlet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, immediate=true, name="ExportRedirectMapServlet", property={"sling.servlet.label=ACS AEM Commons - Export Redirects Servlet", "sling.servlet.methods=GET", "sling.servlet.selectors=export", "sling.servlet.resourceTypes=acs-commons/components/utilities/manage-redirects"})
public class ExportRedirectMapServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ExportRedirectMapServlet.class);
    private static final long serialVersionUID = -3564475196678277711L;
    static final String SPREADSHEETML_SHEET = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String path = request.getParameter("path");
        Resource root = request.getResourceResolver().getResource(path);
        log.debug("Requesting redirect maps from {}", (Object)path);
        Collection<RedirectRule> rules = RedirectFilter.getRules(root);
        XSSFWorkbook wb = ExportRedirectMapServlet.export(rules);
        response.setContentType(SPREADSHEETML_SHEET);
        response.setHeader("Content-Disposition", "attachment;filename=\"acs-redirects.xlsx\" ");
        wb.write((OutputStream)response.getOutputStream());
    }

    static XSSFWorkbook export(Collection<RedirectRule> rules) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFCellStyle headerStyle = wb.createCellStyle();
        headerStyle.setFillForegroundColor(IndexedColors.DARK_BLUE.getIndex());
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont headerFont = wb.createFont();
        headerFont.setColor(IndexedColors.WHITE.getIndex());
        headerStyle.setFont((Font)headerFont);
        XSSFCellStyle dateStyle = wb.createCellStyle();
        dateStyle.setDataFormat(wb.createDataFormat().getFormat("mmm d, yyyy"));
        int rownum = 0;
        XSSFSheet sheet = wb.createSheet("Redirects");
        Row headerRow = sheet.createRow(rownum++);
        headerRow.createCell(0).setCellValue("Source Url");
        headerRow.createCell(1).setCellValue("Target Url");
        headerRow.createCell(2).setCellValue("Status Code");
        headerRow.createCell(3).setCellValue("Until Date");
        headerRow.createCell(4).setCellValue("Notes");
        headerRow.createCell(5).setCellValue("Ignore Context Prefix");
        for (Cell cell : headerRow) {
            cell.setCellStyle((CellStyle)headerStyle);
        }
        for (RedirectRule rule : rules) {
            Row row = sheet.createRow(rownum++);
            row.createCell(0).setCellValue(rule.getSource());
            row.createCell(1).setCellValue(rule.getTarget());
            row.createCell(2).setCellValue((double)rule.getStatusCode());
            ZonedDateTime untilDateTime = rule.getUntilDate();
            if (untilDateTime != null) {
                Cell cell = row.createCell(3);
                cell.setCellValue(Date.from(untilDateTime.toInstant()));
                cell.setCellStyle((CellStyle)dateStyle);
            }
            row.createCell(4).setCellValue(rule.getNote());
            row.createCell(5).setCellValue(rule.getContextPrefixIgnored());
        }
        sheet.setAutoFilter(new CellRangeAddress(0, rownum - 1, 0, 2));
        sheet.setColumnWidth(0, 12800);
        sheet.setColumnWidth(1, 12800);
        sheet.setColumnWidth(2, 3840);
        sheet.setColumnWidth(3, 3072);
        sheet.setColumnWidth(4, 25600);
        sheet.setColumnWidth(5, 5120);
        return wb;
    }
}

