/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.remoteassets.impl;

import com.adobe.acs.commons.remoteassets.impl.RemoteAssetsServiceException;
import com.adobe.acs.commons.util.RequireAem;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.Session;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.fluent.Executor;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={RemoteAssetsConfigImpl.class})
@Designate(ocd=Config.class)
public class RemoteAssetsConfigImpl {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAssetsConfigImpl.class);
    private String server = "";
    private String username = "";
    private String password = "";
    private boolean allowInsecureRemote = false;
    private List<String> tagSyncPaths = new ArrayList<String>();
    private List<String> damSyncPaths = new ArrayList<String>();
    private Integer retryDelay;
    private Integer saveInterval;
    private String eventUserData = "";
    private Set<String> whitelistedServiceUsers = new HashSet<String>();
    private Executor remoteAssetsHttpExecutor;
    @Reference(target="(distribution=classic)")
    RequireAem requireAem;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Activate
    protected final void activate(Config config) {
        this.server = config.server_url();
        if (StringUtils.isBlank((CharSequence)this.server)) {
            throw new IllegalArgumentException("Remote server must be specified");
        }
        this.username = config.server_user();
        if (StringUtils.isBlank((CharSequence)this.username)) {
            throw new IllegalArgumentException("Remote server username must be specified");
        }
        this.password = config.server_pass();
        if (StringUtils.isBlank((CharSequence)this.password)) {
            throw new IllegalArgumentException("Remote server password must be specified");
        }
        this.allowInsecureRemote = config.server_insecure();
        this.tagSyncPaths = Stream.of((Object[])ObjectUtils.defaultIfNull((Object)config.tag_paths(), (Object)new String[0])).filter(item -> StringUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
        this.damSyncPaths = Stream.of((Object[])ObjectUtils.defaultIfNull((Object)config.dam_paths(), (Object)new String[0])).filter(item -> StringUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
        this.retryDelay = config.retry_delay();
        this.saveInterval = config.save_interval();
        this.eventUserData = config.event_user_data();
        this.whitelistedServiceUsers = Stream.of((Object[])ObjectUtils.defaultIfNull((Object)config.whitelisted_service_users(), (Object)new String[0])).filter(item -> StringUtils.isNotBlank((CharSequence)item)).collect(Collectors.toSet());
        this.buildRemoteHttpExecutor();
    }

    public String getServer() {
        return this.server;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getTagSyncPaths() {
        return Collections.unmodifiableList(this.tagSyncPaths);
    }

    public List<String> getDamSyncPaths() {
        return Collections.unmodifiableList(this.damSyncPaths);
    }

    public Integer getRetryDelay() {
        return this.retryDelay;
    }

    public Integer getSaveInterval() {
        return this.saveInterval;
    }

    public String getEventUserData() {
        return this.eventUserData;
    }

    public Set<String> getWhitelistedServiceUsers() {
        return Collections.unmodifiableSet(this.whitelistedServiceUsers);
    }

    public Executor getRemoteAssetsHttpExecutor() {
        return this.remoteAssetsHttpExecutor;
    }

    public ResourceResolver getResourceResolver() {
        try {
            HashMap<String, String> userParams = new HashMap<String, String>();
            userParams.put("sling.service.subservice", "remote-assets");
            ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(userParams);
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            if (StringUtils.isNotBlank((CharSequence)this.getEventUserData())) {
                session.getWorkspace().getObservationManager().setUserData(this.getEventUserData());
            }
            return resourceResolver;
        }
        catch (Exception e) {
            LOG.error("Remote assets functionality cannot be enabled - service user login failed");
            throw new RemoteAssetsServiceException(e);
        }
    }

    private void buildRemoteHttpExecutor() {
        URL url;
        try {
            url = new URL(this.server);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Remote server address is malformed");
        }
        if (!url.getProtocol().equalsIgnoreCase("https")) {
            if (this.allowInsecureRemote) {
                LOG.warn("Remote Assets connection is not HTTPS - authentication username and password will be communicated in CLEAR TEXT.  This configuration is NOT recommended, as it may allow credentials to be compromised!");
            } else {
                throw new IllegalArgumentException("Remote server address must be HTTPS so that credentials cannot be compromised.  As an alternative, you may configure remote assets to allow use of a non-HTTPS connection, allowing connection credentials to potentially be compromised AT YOUR OWN RISK.");
            }
        }
        HttpHost host = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        this.remoteAssetsHttpExecutor = Executor.newInstance().auth(host, this.username, this.password).authPreemptive(host);
    }

    @ObjectClassDefinition(name="ACS AEM Commons - Remote Assets - Config")
    public static @interface Config {
        public static final boolean DEFAULT_ALLOW_INSECURE = false;
        public static final String DEFAULT_EVENT_USER_DATA = "changedByWorkflowProcess";
        public static final int DEFAULT_RETRY_DELAY = 15;
        public static final int DEFAULT_SAVE_INTERVAL = 100;

        @AttributeDefinition(name="Server", description="URL to remote server from which to fetch assets (e.g. https://dev-aem-author.client.com:4502)")
        public String server_url() default "";

        @AttributeDefinition(name="Username", description="User to log into the remote server")
        public String server_user() default "";

        @AttributeDefinition(name="Password", description="Password to log into the remote server")
        public String server_pass() default "";

        @AttributeDefinition(name="Allow Insecure Connection", description="Allow non-https connection to remote assets server, allowing potential compromise of connection credentials")
        public boolean server_insecure() default false;

        @AttributeDefinition(name="Tag Sync Paths", description="Paths to sync tags from the remote server (e.g. /content/cq:tags/client)", cardinality=0x7FFFFFFF)
        public String[] tag_paths() default {};

        @AttributeDefinition(name="Asset Sync Paths", description="Paths to sync assets from the remote server (e.g. /content/dam)", cardinality=0x7FFFFFFF)
        public String[] dam_paths() default {};

        @AttributeDefinition(name="Failure Retry Delay (in minutes)", description="Number of minutes the server will wait to attempt to sync a remoteasset that failed a sync attempt (minimum 1)")
        public int retry_delay() default 15;

        @AttributeDefinition(name="Number of Assets to Sync Before Saving", description="Number of asset nodes to sync before saving and refreshing the session during a node sync. The lower the number, the longer the sync will take (default 100)")
        public int save_interval() default 100;

        @AttributeDefinition(name="Event User Data", description="The event user data that will be set during all JCR manipulations performed by remote assets. This can be used in workflow launchers that listen to DAM paths (such as for DAM Update Assets) to exclude unnecessary processing such as rendition generation.")
        public String event_user_data() default "changedByWorkflowProcess";

        @AttributeDefinition(name="Whitelisted Service Users", description="Service users that are allowed to trigger remote asset binary syncs. By default, service user activity never triggers an asset binary sync.", cardinality=0x7FFFFFFF)
        public String[] whitelisted_service_users() default {};
    }
}

