/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.adobe.acs.commons.json.JsonObjectUtil;
import com.adobe.acs.commons.util.PathInfoUtil;
import com.adobe.acs.commons.wcm.impl.AbstractWidgetConfigurationServlet;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.xss.XSSAPI;

@SlingServlet(extensions={"json"}, selectors={"rte"}, resourceTypes={"sling/servlet/default"})
public final class RTEConfigurationServlet
extends AbstractWidgetConfigurationServlet {
    private static final int RTE_HEIGHT = 200;
    private static final int RTE_WIDTH = 430;
    private static final String DEFAULT_CONFIG_NAME = "default";
    @Reference
    private transient XSSAPI xssApi;
    private static final String DEFAULT_CONFIG = "/libs/foundation/components/text/dialog/items/tab1/items/text/rtePlugins";
    private static final String DEFAULT_ROOT_PATH = "/etc/rteconfig";
    @Property(value={"/etc/rteconfig"})
    private static final String PROP_ROOT_PATH = "root.path";
    private static final String EXTERNAL_STYLESHEETS_PROPERTY = "externalStyleSheets";
    private String rootPath;

    @Override
    protected JsonObject createEmptyWidget(String rteName) {
        JsonObject object = new JsonObject();
        object.addProperty("xtype", "richtext");
        object.addProperty("name", "./" + this.xssApi.encodeForJSString(rteName));
        object.addProperty("hideLabel", Boolean.valueOf(true));
        object.addProperty("jcr:primaryType", "cq:Widget");
        return object;
    }

    private void returnDefault(String rteName, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json");
        Resource root = request.getResourceResolver().getResource(DEFAULT_CONFIG);
        if (root == null) {
            this.writeEmptyWidget(rteName, response);
            return;
        }
        this.writeConfigResource(root, rteName, request, response);
    }

    private void writeConfigResource(Resource resource, String rteName, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        JsonObject config;
        JsonObject widget = this.createEmptyWidget(rteName);
        widget.addProperty("width", (Number)430);
        widget.addProperty("height", (Number)200);
        RequestParameterMap map = request.getRequestParameterMap();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            RequestParameter[] params = (RequestParameter[])entry.getValue();
            if (params != null && (params.length > 1 || EXTERNAL_STYLESHEETS_PROPERTY.equals(key))) {
                JsonArray arr = new JsonArray();
                for (int i = 0; i < params.length; ++i) {
                    arr.add((JsonElement)new JsonPrimitive(params[i].getString()));
                }
                widget.add(key, (JsonElement)arr);
                continue;
            }
            if (params == null || params.length != 1) continue;
            widget.addProperty(key, params[0].getString());
        }
        if (widget.has("fieldLabel")) {
            widget.remove("hideLabel");
        }
        if ((config = JsonObjectUtil.toJsonObject(resource)) == null) {
            config = new JsonObject();
        }
        if (config.has("includeDefault") && config.get("includeDefault").getAsBoolean()) {
            config = this.underlay(config, resource.getResourceResolver().getResource(DEFAULT_CONFIG));
        }
        widget.add("rtePlugins", (JsonElement)config);
        JsonObject parent = new JsonObject();
        parent.addProperty("xtype", "dialogfieldset");
        parent.addProperty("border", Boolean.valueOf(false));
        parent.addProperty("padding", (Number)0);
        parent.add("items", (JsonElement)widget);
        Gson gson = new Gson();
        gson.toJson((JsonElement)parent, (Appendable)response.getWriter());
    }

    @Activate
    protected void activate(Map<String, Object> props) {
        this.rootPath = PropertiesUtil.toString((Object)props.get(PROP_ROOT_PATH), (String)DEFAULT_ROOT_PATH);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String componentPath = request.getResource().getPath();
        String configName = PathInfoUtil.getSelector(request, 1, DEFAULT_CONFIG_NAME);
        String rteName = PathInfoUtil.getSelector(request, 2, "text");
        Resource root = request.getResourceResolver().getResource(this.rootPath);
        if (root != null) {
            Iterator children = root.listChildren();
            while (children.hasNext()) {
                Resource child = (Resource)children.next();
                if (!this.matches(componentPath, child)) continue;
                Resource config = child.getChild(configName);
                if (config == null) {
                    config = child.getChild(DEFAULT_CONFIG_NAME);
                }
                if (config == null) continue;
                this.writeConfigResource(config, rteName, request, response);
                return;
            }
        }
        this.returnDefault(rteName, request, response);
    }

    protected void bindXssApi(XSSAPI xSSAPI) {
        this.xssApi = xSSAPI;
    }

    protected void unbindXssApi(XSSAPI xSSAPI) {
        if (this.xssApi == xSSAPI) {
            this.xssApi = null;
        }
    }
}

