/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentfinder.querybuilder.impl.viewhandler;

import com.adobe.acs.commons.contentfinder.querybuilder.impl.ContentFinderHitBuilder;
import com.day.cq.search.Query;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.core.contentfinder.Hit;
import com.day.cq.wcm.core.contentfinder.ViewQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryBuilderViewQuery
implements ViewQuery {
    private static final Logger log = LoggerFactory.getLogger(QueryBuilderViewQuery.class);
    private final Query query;
    private List<Hit> hits = null;

    public QueryBuilderViewQuery(Query query) {
        this.query = query;
    }

    public Collection<Hit> execute() {
        if (this.hits == null) {
            this.hits = new ArrayList<Hit>();
            if (this.query == null) {
                return Collections.unmodifiableList(this.hits);
            }
            SearchResult result = this.query.getResult();
            for (com.day.cq.search.result.Hit hit : result.getHits()) {
                try {
                    this.hits.add(this.createHit(hit));
                }
                catch (RepositoryException e) {
                    log.error("Could not return required information for Content Finder result: {}", (Object)hit);
                }
            }
        }
        return Collections.unmodifiableList(this.hits);
    }

    private Hit createHit(com.day.cq.search.result.Hit hit) throws RepositoryException {
        Map<String, Object> map = ContentFinderHitBuilder.buildGenericResult(hit);
        Hit cfHit = new Hit();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            cfHit.set(entry.getKey(), entry.getValue());
        }
        return cfHit;
    }
}

