/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.forms.impl;

import com.adobe.acs.commons.forms.Form;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormImpl
implements Form {
    private static final Logger log = LoggerFactory.getLogger(Form.class);
    private final Map<String, String> data;
    private final Map<String, String> errors;
    private String name;
    private String resourcePath;

    public FormImpl(String name, String resourcePath) {
        this.name = name;
        this.resourcePath = resourcePath;
        this.data = new HashMap<String, String>();
        this.errors = new HashMap<String, String>();
    }

    public FormImpl(String name, String resourcePath, Map<String, String> data) {
        this.name = name;
        this.resourcePath = resourcePath;
        this.data = data;
        this.errors = new HashMap<String, String>();
    }

    public FormImpl(String name, String resourcePath, Map<String, String> data, Map<String, String> errors) {
        this.name = name;
        this.resourcePath = resourcePath;
        this.data = data;
        this.errors = errors;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public Map<String, String> getData() {
        return this.data;
    }

    @Override
    public Map<String, String> getErrors() {
        return this.errors;
    }

    @Override
    public boolean has(String key) {
        String val = this.get(key);
        return StringUtils.isNotBlank((String)val);
    }

    @Override
    public String get(String key) {
        String val = this.data.get(key);
        return StringUtils.stripToEmpty((String)val);
    }

    @Override
    public void set(String key, String value) {
        this.data.put(key, value);
    }

    @Override
    public boolean hasData() {
        if (this.data.isEmpty()) {
            return false;
        }
        for (String key : this.data.keySet()) {
            if (!this.has(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasError(String key) {
        return this.errors.containsKey(key);
    }

    @Override
    public String getError(String key) {
        String val = this.errors.get(key);
        return StringUtils.stripToEmpty((String)val);
    }

    @Override
    public void setError(String key) {
        this.errors.put(key, null);
    }

    @Override
    public void setError(String key, String value) {
        this.errors.put(key, value);
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public ValueMap getValueMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(this.data);
        return new ValueMapDecorator(map);
    }

    @Override
    public ValueMap getErrorsValueMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(this.errors);
        return new ValueMapDecorator(map);
    }
}

