/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl;

import com.adobe.acs.commons.mcp.model.ArchivedProcessFailure;
import com.adobe.acs.commons.mcp.model.ManagedProcess;
import com.day.cq.commons.jcr.JcrUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"acs-commons/components/utilities/process-instance"}, selectors={"errors"}, extensions={"xlsx", "xls"})
public class ProcessErrorReportExcelServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessErrorReportExcelServlet.class);

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block9: {
            ManagedProcess report = (ManagedProcess)request.getResource().adaptTo(ManagedProcess.class);
            if (report != null) {
                String title = report.getName();
                String fileName = JcrUtil.createValidName((String)title) + ".xlsx";
                Workbook workbook = this.createSpreadsheet(report);
                response.setContentType("application/vnd.ms-excel");
                response.setHeader("Expires", "0");
                response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                response.setHeader("Pragma", "public");
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
                try (ServletOutputStream out = response.getOutputStream();){
                    workbook.write((OutputStream)out);
                    out.flush();
                    break block9;
                }
                catch (Exception ex) {
                    LOG.error("Error generating excel export for " + request.getResource().getPath(), (Throwable)ex);
                    throw ex;
                }
            }
            String msg = String.format("Unable to process report stored at %s", request.getResource().getPath());
            throw new ServletException(msg);
        }
    }

    protected Workbook createSpreadsheet(ManagedProcess report) {
        XSSFWorkbook wb = new XSSFWorkbook();
        String name = report.getName();
        for (char ch : new char[]{'\\', '/', '*', '[', ']', ':', '?'}) {
            name = StringUtils.remove((String)name, (char)ch);
        }
        Sheet sheet = wb.createSheet(name);
        sheet.createFreezePane(0, 1, 0, 1);
        Row headerRow = sheet.createRow(0);
        CellStyle headerStyle = this.createHeaderStyle((Workbook)wb);
        CellStyle dateStyle = wb.createCellStyle();
        CreationHelper createHelper = wb.getCreationHelper();
        dateStyle.setDataFormat(createHelper.createDataFormat().getFormat("yyy/mm/dd h:mm:ss"));
        for (String columnName : Arrays.asList("Time", "Path", "Error", "Stack trace")) {
            Cell headerCell = headerRow.createCell(headerRow.getPhysicalNumberOfCells());
            headerCell.setCellValue(columnName);
            headerCell.setCellStyle(headerStyle);
        }
        Collection<ArchivedProcessFailure> rows = report.getReportedErrorsList();
        for (ArchivedProcessFailure error : rows) {
            Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            Cell c = row.createCell(0);
            c.setCellValue(error.time);
            c.setCellStyle(dateStyle);
            c = row.createCell(1);
            c.setCellValue(error.nodePath);
            c = row.createCell(2);
            c.setCellValue(error.error);
            c = row.createCell(3);
            c.setCellValue(error.stackTrace);
        }
        this.autosize(sheet, 4);
        sheet.setAutoFilter(new CellRangeAddress(0, 1 + rows.size(), 0, 3));
        return wb;
    }

    CellStyle createHeaderStyle(Workbook wb) {
        XSSFCellStyle xstyle = (XSSFCellStyle)wb.createCellStyle();
        XSSFColor header = new XSSFColor(new Color(79, 129, 189));
        xstyle.setFillForegroundColor(header);
        xstyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont font = (XSSFFont)wb.createFont();
        font.setColor(IndexedColors.WHITE.index);
        xstyle.setFont((Font)font);
        return xstyle;
    }

    int getColumnBlockSize() {
        return 256;
    }

    int getMaxColumnBlockCount() {
        return 120;
    }

    int getMinColumnBlockCount() {
        return 20;
    }

    int getPreferredMinBlockCount() {
        return 12;
    }

    void autosize(Sheet sheet, int lastColumnIndex) {
        for (int i = 0; i <= lastColumnIndex; ++i) {
            try {
                sheet.autoSizeColumn(i);
            }
            catch (Throwable e) {
                LOG.warn("autoSizeColumn({}) failed: {}", (Object)i, (Object)e.getMessage());
            }
            int cw = sheet.getColumnWidth(i);
            if (cw / this.getColumnBlockSize() < this.getMinColumnBlockCount()) {
                sheet.setColumnWidth(i, this.getColumnBlockSize() * this.getPreferredMinBlockCount());
                continue;
            }
            if (cw / this.getColumnBlockSize() <= this.getMaxColumnBlockCount()) continue;
            sheet.setColumnWidth(i, this.getColumnBlockSize() * this.getMaxColumnBlockCount());
        }
    }
}

