/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import com.adobe.acs.commons.redirects.models.SubstitutionElement;
import com.adobe.granite.security.user.util.AuthorizableUtil;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.PostConstruct;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class RedirectRule {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SOURCE_PROPERTY_NAME = "source";
    public static final String TARGET_PROPERTY_NAME = "target";
    public static final String STATUS_CODE_PROPERTY_NAME = "statusCode";
    public static final String UNTIL_DATE_PROPERTY_NAME = "untilDate";
    public static final String NOTE_PROPERTY_NAME = "note";
    public static final String CONTEXT_PREFIX_IGNORED_PROPERTY_NAME = "contextPrefixIgnored";
    public static final String CREATED_PROPERTY_NAME = "jcr:created";
    public static final String CREATED_BY_PROPERTY_NAME = "jcr:createdBy";
    public static final String MODIFIED_PROPERTY_NAME = "jcr:lastModified";
    public static final String MODIFIED_BY_PROPERTY_NAME = "jcr:lastModifiedBy";
    public static final String TAGS_PROPERTY_NAME = "cq:tags";
    @ValueMapValue(injectionStrategy=InjectionStrategy.REQUIRED)
    private String source;
    @ValueMapValue(injectionStrategy=InjectionStrategy.REQUIRED)
    private String target;
    @ValueMapValue(injectionStrategy=InjectionStrategy.REQUIRED)
    private int statusCode;
    @ValueMapValue
    private Calendar untilDate;
    @ValueMapValue
    private String note;
    @ValueMapValue
    private boolean contextPrefixIgnored;
    @ValueMapValue(name="cq:tags")
    private String[] tagIds;
    @ValueMapValue(name="jcr:createdBy")
    private String createdBy;
    @ValueMapValue(name="jcr:lastModifiedBy")
    private String modifiedBy;
    @ValueMapValue(name="jcr:lastModified")
    private Calendar modified;
    @ValueMapValue(name="jcr:created")
    private Calendar created;
    @Self
    private Resource resource;
    private Pattern ptrn;
    private SubstitutionElement[] substitutions;

    @PostConstruct
    protected void init() {
        this.source = this.source.trim();
        this.target = this.target.trim();
        this.createdBy = AuthorizableUtil.getFormattedName((ResourceResolver)this.resource.getResourceResolver(), (String)this.createdBy);
        this.modifiedBy = AuthorizableUtil.getFormattedName((ResourceResolver)this.resource.getResourceResolver(), (String)this.modifiedBy);
        String regex = this.source;
        if (regex.endsWith("*")) {
            regex = regex.replaceAll("\\*$", "(.*)");
        }
        this.ptrn = RedirectRule.toRegex(regex);
        this.substitutions = SubstitutionElement.parse(this.target);
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public String getNote() {
        return this.note;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getContextPrefixIgnored() {
        return this.contextPrefixIgnored;
    }

    public Pattern getRegex() {
        return this.ptrn;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public Calendar getModified() {
        return this.modified;
    }

    public Calendar getUntilDate() {
        return this.untilDate;
    }

    public String[] getTagIds() {
        return this.tagIds;
    }

    public List<Tag> getTags() {
        TagManager tagMgr = (TagManager)this.resource.getResourceResolver().adaptTo(TagManager.class);
        if (this.tagIds == null || tagMgr == null) {
            return Collections.emptyList();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (String tagId : this.tagIds) {
            Tag tag = tagMgr.resolve(tagId);
            if (tag == null) continue;
            tags.add(tag);
        }
        return tags;
    }

    public String toString() {
        return String.format("RedirectRule{source='%s', target='%s', statusCode=%s, untilDate=%s, note=%s, contextPrefixIgnored=%s, tags=%s, created=%s, createdBy=%s, modified=%s, modifiedBy=%s}", this.source, this.target, this.statusCode, this.untilDate, this.note, this.contextPrefixIgnored, Arrays.toString(this.tagIds), this.created, this.createdBy, this.modified, this.modifiedBy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedirectRule that = (RedirectRule)o;
        return Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return this.source != null ? this.source.hashCode() : 0;
    }

    public String evaluate(Matcher matcher) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.substitutions.length; ++i) {
            buf.append(this.substitutions[i].evaluate(matcher));
        }
        return buf.toString();
    }

    static Pattern toRegex(String src) {
        Pattern ptrn;
        try {
            ptrn = Pattern.compile(src);
            int groupCount = ptrn.matcher("").groupCount();
            if (groupCount == 0) {
                ptrn = null;
            }
        }
        catch (PatternSyntaxException e) {
            log.info("invalid regex: {}", (Object)src);
            ptrn = null;
        }
        return ptrn;
    }
}

