/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.util;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtils {
    private static final Logger log = LoggerFactory.getLogger(CacheUtils.class);
    static final String COOKIEPREFIX_HOST = "__Host-";
    static final String COOKIEPREFIX_SECURE = "__Secure-";
    static final String HEADERKEY_COOKIE = "Set-Cookie";

    private CacheUtils() {
    }

    public static File createTemporaryCacheFile(CacheKey cacheKey) throws IOException {
        File file = Files.createTempFile(cacheKey.toString(), ".tmp", new FileAttribute[0]).toFile();
        if (null != file) {
            log.debug("Temp file created with the name - {}", (Object)cacheKey);
        }
        return file;
    }

    public static Map<String, List<String>> extractHeaders(Collection<Pattern> excludedHeaderRegexList, Collection<String> excludedCookieKeyList, SlingHttpServletResponse response, HttpCacheConfig cacheConfig) {
        List excludedHeaders = Stream.concat(excludedHeaderRegexList.stream(), cacheConfig.getExcludedResponseHeaderPatterns().stream()).collect(Collectors.toList());
        List excludedCookieKeys = Stream.concat(excludedCookieKeyList.stream(), cacheConfig.getExcludedCookieKeys().stream()).collect(Collectors.toList());
        return response.getHeaderNames().stream().filter(headerName -> excludedHeaders.stream().noneMatch(pattern -> pattern.matcher((CharSequence)headerName).matches())).collect(Collectors.toMap(headerName -> headerName, headerName -> CacheUtils.filterCookieHeaders(response, excludedCookieKeys, headerName)));
    }

    public static List<String> filterCookieHeaders(SlingHttpServletResponse response, List<String> excludedCookieKeys, String headerName) {
        if (!headerName.equals(HEADERKEY_COOKIE)) {
            return new ArrayList<String>(response.getHeaders(headerName));
        }
        return new ArrayList(response.getHeaders(headerName)).stream().filter(header -> {
            String key = header.startsWith(COOKIEPREFIX_HOST) ? StringUtils.removeStart((String)header, (String)COOKIEPREFIX_HOST) : (header.startsWith(COOKIEPREFIX_SECURE) ? StringUtils.removeStart((String)header, (String)COOKIEPREFIX_SECURE) : header);
            key = StringUtils.substringBefore((String)key, (String)"=");
            return !excludedCookieKeys.contains(key);
        }).collect(Collectors.toList());
    }
}

