/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, immediate=true, name="ImportRedirectMapServlet", property={"sling.servlet.label=ACS AEM Commons - Import Redirects Servlet", "sling.servlet.methods=POST", "sling.servlet.selectors=import", "sling.servlet.resourceTypes=acs-commons/components/utilities/manage-redirects"})
public class ImportRedirectMapServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ImportRedirectMapServlet.class);
    private static final long serialVersionUID = -3564475196678277711L;
    private static final String MIX_CREATED = "mix:created";
    private static final String MIX_LAST_MODIFIED = "mix:lastModified";

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Collection<Map<String, Object>> xlsRules;
        String path = request.getParameter("path");
        Resource storageRoot = request.getResourceResolver().getResource(path);
        log.debug("Updating redirect maps at {}", (Object)storageRoot.getPath());
        Map<String, Resource> jcrRules = this.getRules(storageRoot);
        try (InputStream is = ImportRedirectMapServlet.getFile(request);){
            xlsRules = this.readEntries(is);
        }
        if (!xlsRules.isEmpty()) {
            this.update(storageRoot, xlsRules, jcrRules);
        }
    }

    Map<String, Resource> getRules(Resource resource) {
        LinkedHashMap<String, Resource> rules = new LinkedHashMap<String, Resource>();
        for (Resource res : resource.getChildren()) {
            if (!res.isResourceType("acs-commons/components/utilities/manage-redirects/redirect-row")) continue;
            String src = (String)res.getValueMap().get("source", String.class);
            rules.put(src, res);
        }
        return rules;
    }

    void update(Resource root, Collection<Map<String, Object>> xlsRules, Map<String, Resource> jcrRedirects) throws PersistenceException {
        ResourceResolver resolver = root.getResourceResolver();
        for (Map<String, Object> props : xlsRules) {
            String sourcePath = (String)props.get("source");
            Resource redirect = this.getOrCreateRedirect(root, sourcePath, props, jcrRedirects);
            log.debug("rule: {}", (Object)redirect.getPath());
        }
        resolver.commit();
    }

    private Resource getOrCreateRedirect(Resource root, String sourcePath, Map<String, Object> props, Map<String, Resource> jcrRedirects) throws PersistenceException {
        Resource redirect = jcrRedirects.get(sourcePath);
        if (redirect == null) {
            props.put("jcr:mixinTypes", MIX_CREATED);
            String nodeName = ResourceUtil.createUniqueChildName((Resource)root, (String)"redirect-rule-");
            redirect = root.getResourceResolver().create(root, nodeName, props);
        } else {
            ValueMap valueMap = (ValueMap)redirect.adaptTo(ModifiableValueMap.class);
            if (valueMap == null) {
                throw new PersistenceException("Cannot modify properties of " + redirect.getPath());
            }
            String[] mixins = (String[])valueMap.get("jcr:mixinTypes", String[].class);
            HashSet<String> mset = mixins == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(mixins));
            mset.add(MIX_LAST_MODIFIED);
            props.put("jcr:mixinTypes", mset.toArray(new String[0]));
            valueMap.putAll(props);
        }
        return redirect;
    }

    private Collection<Map<String, Object>> readEntries(InputStream is) throws IOException {
        LinkedHashSet<Map<String, Object>> rules = new LinkedHashSet<Map<String, Object>>();
        XSSFWorkbook wb = new XSSFWorkbook(is);
        Sheet sheet = wb.getSheetAt(0);
        boolean first = true;
        for (Row row : sheet) {
            if (!first) {
                Map<String, Object> props = this.readRedirect(row);
                rules.add(props);
                continue;
            }
            first = false;
        }
        log.debug("{} rules read from spreadsheet", (Object)rules.size());
        return rules;
    }

    private Map<String, Object> readRedirect(Row row) {
        Cell c5;
        Cell c4;
        Cell c12;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("sling:resourceType", "acs-commons/components/utilities/manage-redirects/redirect-row");
        String source = row.getCell(0).getStringCellValue();
        props.put("source", source);
        String target = row.getCell(1).getStringCellValue();
        props.put("target", target);
        int statusCode = (int)row.getCell(2).getNumericCellValue();
        props.put("statusCode", String.valueOf(statusCode));
        Cell c3 = row.getCell(3);
        if (DateUtil.isCellDateFormatted((Cell)c3)) {
            Calendar untilDate = Calendar.getInstance();
            untilDate.setTime(c3.getDateCellValue());
            props.put("untilDate", untilDate);
        }
        if (DateUtil.isCellDateFormatted((Cell)(c12 = row.getCell(12)))) {
            Calendar effectiveFrom = Calendar.getInstance();
            effectiveFrom.setTime(c12.getDateCellValue());
            props.put("effectiveFrom", effectiveFrom);
        }
        if ((c4 = row.getCell(4)) != null) {
            props.put("note", c4.getStringCellValue());
        }
        boolean evaluateURI = (c5 = row.getCell(5)) != null && c5.getBooleanCellValue();
        props.put("evaluateURI", evaluateURI);
        Cell c6 = row.getCell(6);
        boolean ignoreContextPrefix = c6 != null && c6.getBooleanCellValue();
        props.put("contextPrefixIgnored", ignoreContextPrefix);
        Cell c7 = row.getCell(7);
        String[] tagIds = c7 == null ? null : c7.getStringCellValue().split("\n");
        props.put("cq:tags", tagIds);
        return props;
    }

    public static InputStream getFile(SlingHttpServletRequest request) throws IOException {
        InputStream stream = null;
        for (RequestParameter param : request.getRequestParameterList()) {
            if (param.isFormField()) continue;
            stream = param.getInputStream();
            break;
        }
        return stream;
    }
}

