/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.sorter.impl;

import com.adobe.acs.commons.sorter.NodeSorter;
import com.adobe.acs.commons.sorter.impl.HierarchyNodeComparator;
import com.day.cq.commons.JcrLabeledResource;
import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;

@Component
public class NodeTitleSorter
implements NodeSorter {
    public static final String SORTER_NAME = "byTitle";
    public static final String RP_CASE_SENSITIVE = ":caseSensitive";
    public static final String RP_RESPECT_NUMBERS = ":respectNumbers";
    private Comparator<Node> numbersFirstComparator = (n1, n2) -> {
        try {
            String title2;
            String title1 = new JcrLabeledResource(n1).getTitle();
            if (title1 == null) {
                title1 = n1.getName();
            }
            if ((title2 = new JcrLabeledResource(n2).getTitle()) == null) {
                title2 = n2.getName();
            }
            return Boolean.compare(StringUtils.isNumeric((CharSequence)title2), StringUtils.isNumeric((CharSequence)title1));
        }
        catch (RepositoryException e) {
            return 0;
        }
    };

    @Override
    public String getName() {
        return SORTER_NAME;
    }

    @Override
    public String getLabel() {
        return "By Node Title";
    }

    @Override
    public Comparator<Node> createComparator(HttpServletRequest request) {
        boolean caseSensitive = Boolean.parseBoolean(request.getParameter(RP_CASE_SENSITIVE));
        boolean respectNumbers = Boolean.parseBoolean(request.getParameter(RP_RESPECT_NUMBERS));
        boolean nonHierarchyFirst = request.getParameter(":nonHierarchyFirst") == null || Boolean.parseBoolean(request.getParameter(":nonHierarchyFirst"));
        Comparator<Node> comparator = (n1, n2) -> 0;
        if (nonHierarchyFirst) {
            comparator = comparator.thenComparing(HierarchyNodeComparator.INSTANCE);
        }
        if (respectNumbers) {
            comparator = comparator.thenComparing(this.numbersFirstComparator);
        }
        comparator = comparator.thenComparing((n1, n2) -> {
            try {
                String title2;
                String title1 = new JcrLabeledResource(n1).getTitle();
                if (title1 == null) {
                    title1 = n1.getName();
                }
                if ((title2 = new JcrLabeledResource(n2).getTitle()) == null) {
                    title2 = n2.getName();
                }
                if (respectNumbers && StringUtils.isNumeric((CharSequence)title1) && StringUtils.isNumeric((CharSequence)title2)) {
                    Integer number1 = Integer.valueOf(title1);
                    Integer number2 = Integer.valueOf(title2);
                    return number1.compareTo(number2);
                }
                return caseSensitive ? title1.compareTo(title2) : title1.compareToIgnoreCase(title2);
            }
            catch (RepositoryException e) {
                return 0;
            }
        });
        return comparator;
    }
}

