/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import com.adobe.cq.dialogconversion.AbstractDialogRewriteRule;
import com.adobe.cq.dialogconversion.DialogRewriteException;
import com.adobe.cq.dialogconversion.DialogRewriteUtils;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
public final class GraphicIconSelectionDialogRewriteRule
extends AbstractDialogRewriteRule {
    private static final String PN_OPTIONS = "options";
    private static final String XTYPE = "graphiciconselection";
    private static final String[] PROPERTIES_TO_COPY = new String[]{"name", "fieldLabel", "fieldDescription"};
    private static final String PN_SLING_RESOURCE_TYPE = "sling:resourceType";

    public Node applyTo(Node root, Set<Node> finalNodes) throws DialogRewriteException, RepositoryException {
        String options;
        Node parent = root.getParent();
        String name = root.getName();
        DialogRewriteUtils.rename((Node)root);
        Node newRoot = parent.addNode(name, "nt:unstructured");
        finalNodes.add(newRoot);
        for (String propertyName : PROPERTIES_TO_COPY) {
            DialogRewriteUtils.copyProperty((Node)root, (String)propertyName, (Node)newRoot, (String)propertyName);
        }
        newRoot.setProperty(PN_SLING_RESOURCE_TYPE, "acs-commons/components/authoring/graphiciconselect");
        if (root.hasProperty(PN_OPTIONS) && (options = root.getProperty(PN_OPTIONS).getString()).startsWith("/etc/acs-commons/lists")) {
            Node dataSource = newRoot.addNode("datasource", "nt:unstructured");
            dataSource.setProperty(PN_SLING_RESOURCE_TYPE, "acs-commons/components/utilities/genericlist/datasource");
            dataSource.setProperty("path", StringUtils.substringBeforeLast((String)options, (String)"/"));
        }
        root.remove();
        return newRoot;
    }

    public boolean matches(Node root) throws RepositoryException {
        return DialogRewriteUtils.hasXtype((Node)root, (String)XTYPE);
    }
}

