/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.quickly.operations.impl;

import com.adobe.acs.commons.quickly.Command;
import com.adobe.acs.commons.quickly.operations.AbstractOperation;
import com.adobe.acs.commons.quickly.results.Action;
import com.adobe.acs.commons.quickly.results.Result;
import com.adobe.granite.license.ProductInfo;
import com.adobe.granite.license.ProductInfoService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(name="cmd", value={"docs"}), @Property(name="description", value={"Search Docs"})})
@Service
public class DuckDuckGoDocsOperationImpl
extends AbstractOperation {
    public static final String CMD = "docs";
    private static final Logger log = LoggerFactory.getLogger(DuckDuckGoDocsOperationImpl.class);
    @Reference
    private ProductInfoService productInfoService;
    private String aemVersion = "6-0";
    private String productName = "aem";

    @Override
    public boolean accepts(SlingHttpServletRequest request, Command cmd) {
        return StringUtils.endsWithIgnoreCase((String)CMD, (String)cmd.getOp());
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    protected List<Result> withoutParams(SlingHttpServletRequest request, SlingHttpServletResponse response, Command cmd) {
        ArrayList<Result> results = new ArrayList<Result>();
        Result result = new Result.Builder("docs.adobe.com").description("http://docs.adobe.com").action(new Action.Builder().uri("http://docs.adobe.com").target(Action.Target.BLANK).build()).build();
        results.add(result);
        return results;
    }

    @Override
    protected List<Result> withParams(SlingHttpServletRequest request, SlingHttpServletResponse response, Command cmd) {
        ArrayList<Result> results = new ArrayList<Result>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "site:docs.adobe.com/docs/en/" + this.productName + "/" + this.aemVersion + " AND " + cmd.getParam());
        Result result = new Result.Builder("Search AEM documentation").description("Search for: " + cmd.getParam()).action(new Action.Builder().uri("https://duckduckgo.com").target(Action.Target.BLANK).params(params).build()).build();
        results.add(result);
        return results;
    }

    @Activate
    protected void activate(Map<String, String> config) {
        ProductInfo productInfo = null;
        for (ProductInfo i : this.productInfoService.getInfos()) {
            String shortName = i.getShortName();
            if (!shortName.equalsIgnoreCase("cq") && !shortName.equalsIgnoreCase("aem")) continue;
            productInfo = i;
            break;
        }
        if (productInfo != null) {
            this.aemVersion = String.format("%s-%s", productInfo.getVersion().getMajor(), productInfo.getVersion().getMinor());
        }
        log.debug("AEM Version: {}", (Object)this.aemVersion);
        log.debug("Product Name: {}", (Object)this.productName);
    }

    protected void bindProductInfoService(ProductInfoService productInfoService) {
        this.productInfoService = productInfoService;
    }

    protected void unbindProductInfoService(ProductInfoService productInfoService) {
        if (this.productInfoService == productInfoService) {
            this.productInfoService = null;
        }
    }
}

