/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.transformers.impl;

import com.adobe.acs.commons.images.ImageTransformer;
import com.day.image.Layer;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(name="type", value={"sharpen"})})
@Service
public class SharpenImageTransformerImpl
implements ImageTransformer {
    private static final Logger log = LoggerFactory.getLogger(SharpenImageTransformerImpl.class);
    static final String TYPE = "sharpen";
    private static final String KEY_UNSHARP_MASK = "op_usm";
    private static final int NUM_SHARPEN_PARAMS = 2;

    @Override
    public final Layer transform(Layer layer, ValueMap properties) {
        if (properties == null || properties.isEmpty()) {
            log.warn("Transform [ {} ] requires parameters.", (Object)TYPE);
            return layer;
        }
        log.debug("Transforming with [ {} ]", (Object)TYPE);
        String unsharpenMask = StringUtils.trim((String)((String)properties.get(KEY_UNSHARP_MASK, String.class)));
        try {
            if (!unsharpenMask.isEmpty()) {
                String[] param = unsharpenMask.split(",");
                if (param.length == 2) {
                    float amount = Float.parseFloat(param[0]);
                    float radius = Float.parseFloat(param[1]);
                    layer.sharpen(amount, radius);
                } else {
                    log.warn("Transform [ {} ] requires 2 parameters.", (Object)TYPE);
                }
            }
        }
        catch (NumberFormatException exception) {
            log.warn("Transform [ {} ] requires floating type values.", (Object)TYPE);
            log.error("Exception occured while parsing string to float", (Throwable)exception);
        }
        return layer;
    }
}

