/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import com.adobe.acs.commons.redirects.filter.RedirectFilterMBean;
import com.adobe.acs.commons.redirects.models.RedirectConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

@Model(adaptables={SlingHttpServletRequest.class})
public class Configurations {
    @SlingObject
    private SlingHttpServletRequest request;
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    private RedirectFilterMBean redirectFilter;
    private static final String REDIRECTS_RESOURCE_TYPE = "acs-commons/components/utilities/manage-redirects/redirects";

    public Collection<RedirectConfiguration> getConfigurations() {
        ArrayList<RedirectConfiguration> configurations = new ArrayList<RedirectConfiguration>();
        String bucketName = this.redirectFilter != null ? this.redirectFilter.getBucket() : "settings";
        String configName = this.redirectFilter != null ? this.redirectFilter.getConfigName() : "redirects";
        String storageSuffix = bucketName + "/" + configName;
        Resource confRoot = this.request.getResourceResolver().getResource("/conf");
        for (Resource child : confRoot.getChildren()) {
            Resource res = child.getChild(storageSuffix);
            if (res == null || !res.isResourceType(REDIRECTS_RESOURCE_TYPE)) continue;
            configurations.add(new RedirectConfiguration(res, storageSuffix));
        }
        configurations.sort(Comparator.comparing(RedirectConfiguration::getName));
        return configurations;
    }
}

