/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.servlets;

import com.adobe.acs.commons.redirects.filter.RedirectFilter;
import com.adobe.acs.commons.redirects.models.RedirectRule;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.extensions=txt", "sling.servlet.resourceTypes=acs-commons/components/utilities/manage-redirects/redirects"})
public class RewriteMapServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = -3564475196678277711L;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType(ContentType.TEXT_PLAIN.getMimeType());
        String[] selectors = request.getRequestPathInfo().getSelectors();
        int statusCode = 0;
        if (selectors != null && selectors.length > 0) {
            statusCode = Integer.parseInt(selectors[0]);
        }
        Collection<RedirectRule> rules = RedirectFilter.getRules(request.getResource());
        PrintWriter out = response.getWriter();
        out.printf("# %s Redirects\n", statusCode == 0 ? "All" : "" + statusCode);
        for (RedirectRule rule : rules) {
            if (statusCode != 0 && rule.getStatusCode() != statusCode) continue;
            String note = rule.getNote();
            if (note != null && !note.isEmpty()) {
                out.printf("# %s\n", note);
            }
            out.printf("%s %s\n", rule.getSource(), rule.getTarget());
        }
    }
}

