/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentsync.servlet;

import com.adobe.acs.commons.contentsync.CatalogItem;
import com.adobe.acs.commons.contentsync.UpdateStrategy;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={Servlet.class}, immediate=true, property={"sling.servlet.extensions=json", "sling.servlet.selectors=catalog", "sling.servlet.resourceTypes=acs-commons/components/utilities/contentsync"})
public class ContentCatalogServlet
extends SlingSafeMethodsServlet {
    private final transient Map<String, UpdateStrategy> updateStrategies = Collections.synchronizedMap(new LinkedHashMap());

    @Reference(service=UpdateStrategy.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindDeltaStrategy(UpdateStrategy strategy) {
        if (strategy != null) {
            String key = strategy.getClass().getName();
            this.updateStrategies.put(key, strategy);
        }
    }

    protected void unbindDeltaStrategy(UpdateStrategy strategy) {
        String key = strategy.getClass().getName();
        this.updateStrategies.remove(key);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        JsonObjectBuilder result = Json.createObjectBuilder();
        try {
            JsonArrayBuilder resources = Json.createArrayBuilder();
            String pid = request.getParameter("strategy");
            UpdateStrategy updateStrategy = this.getStrategy(pid);
            List<CatalogItem> items = updateStrategy.getItems(request);
            for (CatalogItem item : items) {
                resources.add((JsonValue)item.getJsonObject());
            }
            result.add("resources", resources);
        }
        catch (Exception e) {
            result.add("error", e.getMessage());
            response.setStatus(500);
        }
        try (JsonWriter out = Json.createWriter((Writer)response.getWriter());){
            out.writeObject(result.build());
        }
    }

    UpdateStrategy getStrategy(String pid) {
        UpdateStrategy strategy;
        if (pid == null) {
            strategy = this.updateStrategies.values().iterator().next();
        } else {
            strategy = this.updateStrategies.get(pid);
            if (strategy == null) {
                throw new IllegalArgumentException("Cannot find UpdateStrategy for pid " + pid + ". Available strategies: " + this.updateStrategies.values().stream().map(s -> s.getClass().getName()).collect(Collectors.toList()));
            }
        }
        return strategy;
    }
}

