/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.ondeploy.scripts;

import com.adobe.acs.commons.cqsearch.QueryUtil;
import com.adobe.acs.commons.ondeploy.scripts.OnDeployScript;
import com.adobe.acs.commons.ondeploy.scripts.OnDeployScriptException;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.PageManager;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.annotation.versioning.ConsumerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConsumerType
public abstract class OnDeployScriptBase
implements OnDeployScript {
    private static final String SLING_RESOURCE_TYPE = "sling:resourceType";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PageManager pageManager;
    private ResourceResolver resourceResolver;
    private Session session;
    private Workspace workspace;

    @Override
    public final void execute(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        this.pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        this.session = (Session)resourceResolver.adaptTo(Session.class);
        if (this.session != null) {
            this.workspace = this.session.getWorkspace();
        }
        try {
            this.execute();
            resourceResolver.commit();
        }
        catch (Exception e) {
            throw new OnDeployScriptException(e);
        }
    }

    protected abstract void execute() throws Exception;

    protected final Node getOrCreateNode(String absolutePath) throws RepositoryException {
        return this.getOrCreateNode(absolutePath, "nt:unstructured", "nt:unstructured");
    }

    protected final Node getOrCreateNode(String absolutePath, String nodeType) throws RepositoryException {
        return this.getOrCreateNode(absolutePath, "nt:unstructured", nodeType);
    }

    protected final Node getOrCreateNode(String absolutePath, String intermediateNodeType, String nodeType) throws RepositoryException {
        try {
            return this.session.getNode(absolutePath);
        }
        catch (PathNotFoundException e) {
            this.logger.warn("Creating node (and missing parents): {}", (Object)absolutePath);
            return JcrUtil.createPath((String)absolutePath, (String)intermediateNodeType, (String)nodeType, (Session)this.session, (boolean)false);
        }
    }

    protected final void renameProperty(Node node, String oldPropertyName, String newPropertyName) throws RepositoryException {
        Resource resource = this.resourceResolver.getResource(node.getPath());
        this.renameProperty(resource, oldPropertyName, newPropertyName);
    }

    protected final void renameProperty(Resource resource, String oldPropertyName, String newPropertyName) {
        ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        if (properties.containsKey((Object)oldPropertyName)) {
            this.logger.info("Renaming property '{}' to '{}' on resource: {}", new Object[]{oldPropertyName, newPropertyName, resource.getPath()});
            properties.put((Object)newPropertyName, properties.get((Object)oldPropertyName));
            properties.remove((Object)oldPropertyName);
        } else {
            this.logger.debug("Property '{}' does not exist on resource: {}", (Object)oldPropertyName, (Object)resource.getPath());
        }
    }

    protected final void removeResource(String path) throws RepositoryException {
        Resource resource = this.resourceResolver.getResource(path);
        if (resource != null) {
            this.logger.info("Deleting node at {}", (Object)path);
            this.session.removeItem(path);
        } else {
            this.logger.info("Node at {} has already been removed", (Object)path);
        }
    }

    protected final void searchAndUpdateResourceType(String oldResourceType, String newResourceType) throws RepositoryException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("p.limit", "-1");
        map.put("path", "/content");
        map.put("1_property", SLING_RESOURCE_TYPE);
        map.put("1_property.value", oldResourceType);
        this.logger.info("Finding all nodes under /content with resource type: {}", (Object)oldResourceType);
        QueryBuilder queryBuilder = (QueryBuilder)this.resourceResolver.adaptTo(QueryBuilder.class);
        if (queryBuilder != null) {
            Query query = queryBuilder.createQuery(PredicateGroup.create(map), this.session);
            QueryUtil.setResourceResolverOn(this.resourceResolver, query);
            SearchResult result = query.getResult();
            Iterator nodeItr = result.getNodes();
            if (nodeItr.hasNext()) {
                while (nodeItr.hasNext()) {
                    Node node = (Node)nodeItr.next();
                    this.updateResourceType(node, newResourceType);
                }
            } else {
                this.logger.info("No nodes found with resource type: {}", (Object)oldResourceType);
            }
        }
    }

    protected final void updateResourceType(Node node, String resourceType) throws RepositoryException {
        boolean hasResourceType = node.hasProperty(SLING_RESOURCE_TYPE);
        if (!hasResourceType || !resourceType.equals(node.getProperty(SLING_RESOURCE_TYPE).getString())) {
            this.logger.info("Updating node at {} to resource type: {}", (Object)node.getPath(), (Object)resourceType);
            node.setProperty(SLING_RESOURCE_TYPE, resourceType);
        } else {
            this.logger.info("Node at {} is already resource type: {}", (Object)node.getPath(), (Object)resourceType);
        }
    }

    protected final ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    protected final PageManager getPageManager() {
        return this.pageManager;
    }

    protected final Session getSession() {
        return this.session;
    }

    protected final Workspace getWorkspace() {
        return this.workspace;
    }
}

