/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentsync;

import com.adobe.acs.commons.contentsync.CatalogItem;
import com.adobe.acs.commons.contentsync.RemoteInstance;
import com.adobe.acs.commons.contentsync.UpdateStrategy;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class ContentCatalog {
    private RemoteInstance remoteInstance;
    private final String catalogServlet;
    private List<CatalogItem> results;

    public ContentCatalog(RemoteInstance remoteInstance, String catalogServlet) {
        this.remoteInstance = remoteInstance;
        this.catalogServlet = catalogServlet;
    }

    public URI getStartCatalogJobURI(String path, String updateStrategy, boolean recursive) throws URISyntaxException {
        return this.remoteInstance.toURI(this.catalogServlet, "root", path, "strategy", updateStrategy, "recursive", String.valueOf(recursive));
    }

    public URI getStatusCatalogJobURI(String jobId) throws URISyntaxException {
        return this.remoteInstance.toURI(this.catalogServlet, "jobId", jobId);
    }

    void checkStatus(JsonObject json) {
        String status;
        JsonArray resources = json.getJsonArray("resources");
        String string = status = json.containsKey((Object)"status") ? json.getString("status") : null;
        if ("SUCCEEDED".equals(status) || resources != null) {
            this.results = resources.stream().map(JsonValue::asJsonObject).map(CatalogItem::new).collect(Collectors.toList());
        } else if ("ERROR".equals(status) || "GIVEN_UP".equals(status)) {
            String resultMessage = json.containsKey((Object)"message") ? json.getString("message") : "";
            throw new IllegalStateException("Error fetching catalog: " + resultMessage);
        }
    }

    public String startCatalogJob(String path, String updateStrategy, boolean recursive) throws IOException, URISyntaxException {
        URI uri = this.getStartCatalogJobURI(path, updateStrategy, recursive);
        JsonObject json = this.remoteInstance.getJson(uri);
        this.checkStatus(json);
        return json.containsKey((Object)"jobId") ? json.getString("jobId") : null;
    }

    public boolean isComplete(String jobId) throws IOException, URISyntaxException {
        if (this.results != null) {
            return true;
        }
        URI uri = this.getStatusCatalogJobURI(jobId);
        JsonObject json = this.remoteInstance.getJson(uri);
        this.checkStatus(json);
        return this.results != null;
    }

    public List<CatalogItem> getResults() {
        return this.results;
    }

    public List<CatalogItem> getDelta(List<CatalogItem> catalog, ResourceResolver resourceResolver, UpdateStrategy updateStrategy) {
        ArrayList<CatalogItem> lst = new ArrayList<CatalogItem>();
        for (CatalogItem item : catalog) {
            Resource resource = resourceResolver.getResource(item.getPath());
            if (resource != null && !updateStrategy.isModified(item, resource)) continue;
            lst.add(item);
        }
        return lst;
    }

    @Deprecated
    public URI getFetchURI(String path, String updateStrategy) throws URISyntaxException {
        return this.getFetchURI(path, updateStrategy, true);
    }

    @Deprecated
    public URI getFetchURI(String path, String updateStrategy, boolean recursive) throws URISyntaxException {
        return this.remoteInstance.toURI(this.catalogServlet, "root", path, "strategy", updateStrategy, "recursive", String.valueOf(recursive));
    }

    @Deprecated
    public List<CatalogItem> fetch(String path, String updateStrategy) throws IOException, URISyntaxException {
        return this.fetch(path, updateStrategy, true);
    }

    @Deprecated
    public List<CatalogItem> fetch(String path, String updateStrategy, boolean recursive) throws IOException, URISyntaxException {
        JsonObject response;
        URI uri = this.getFetchURI(path, updateStrategy, recursive);
        String json = this.remoteInstance.getString(uri);
        try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
            response = reader.readObject();
        }
        if (!response.containsKey((Object)"resources")) {
            throw new IOException("Failed to fetch content catalog from " + uri + ", Response: " + json);
        }
        JsonArray catalog = response.getJsonArray("resources");
        return catalog.stream().map(JsonValue::asJsonObject).map(CatalogItem::new).collect(Collectors.toList());
    }
}

