/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentsync;

import com.adobe.acs.commons.contentsync.CatalogItem;
import com.adobe.acs.commons.contentsync.RemoteInstance;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.model.WorkflowModel;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionManager;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.jcr.contentloader.ContentImporter;
import org.apache.sling.jcr.contentloader.ImportOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentSync {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private RemoteInstance remoteInstance;
    private ContentImporter importer;
    private ResourceResolver resourceResolver;

    public ContentSync(RemoteInstance remoteInstance, ResourceResolver resourceResolver, ContentImporter importer) {
        this.remoteInstance = remoteInstance;
        this.resourceResolver = resourceResolver;
        this.importer = importer;
    }

    public List<String> sort(Node node) throws RepositoryException, IOException, URISyntaxException {
        List<String> children = this.remoteInstance.listChildren(node.getPath());
        this.sort(node, children);
        return children;
    }

    public void sort(Node node, List<String> children) throws RepositoryException {
        if (!node.getPrimaryNodeType().hasOrderableChildNodes()) {
            return;
        }
        Node prev = null;
        for (int i = 0; i < children.size(); ++i) {
            String childName = children.get(children.size() - 1 - i);
            if (!node.hasNode(childName)) continue;
            Node n = node.getNode(childName);
            if (prev != null) {
                node.orderBefore(n.getName(), prev.getName());
            }
            prev = n;
        }
    }

    public void copyBinaries(List<String> propertyPaths) throws IOException, RepositoryException, URISyntaxException {
        Session session = (Session)this.resourceResolver.adaptTo(Session.class);
        for (String propertyPath : propertyPaths) {
            InputStream ntData = this.remoteInstance.getStream(propertyPath);
            try {
                Binary binary = session.getValueFactory().createBinary(ntData);
                Property p = session.getProperty(propertyPath);
                if (p.getType() == 2) {
                    p.setValue(binary);
                    continue;
                }
                Node propertyNode = p.getParent();
                String propertyName = p.getName();
                p.remove();
                propertyNode.setProperty(propertyName, binary);
            }
            finally {
                if (ntData == null) continue;
                ntData.close();
            }
        }
    }

    public ImportOptions getImportOptions() {
        return new ImportOptions(){

            public boolean isCheckin() {
                return false;
            }

            public boolean isAutoCheckout() {
                return true;
            }

            public boolean isIgnoredImportProvider(String extension) {
                return false;
            }

            public boolean isOverwrite() {
                return false;
            }

            public boolean isPropertyOverwrite() {
                return true;
            }
        };
    }

    public void clearContent(Node node) throws RepositoryException {
        if (!node.hasNode("jcr:content")) {
            return;
        }
        Node jcrContent = node.getNode("jcr:content");
        if (!jcrContent.isCheckedOut()) {
            VersionManager versionManager = node.getSession().getWorkspace().getVersionManager();
            versionManager.checkout(jcrContent.getPath());
        }
        NodeIterator iterator = jcrContent.getNodes();
        while (iterator.hasNext()) {
            Node n = iterator.nextNode();
            n.remove();
        }
        iterator = jcrContent.getProperties();
        while (iterator.hasNext()) {
            Property p = iterator.nextProperty();
            if (p.getDefinition().isProtected()) continue;
            p.remove();
        }
    }

    public Node ensureParent(String path) throws RepositoryException, IOException, URISyntaxException {
        Node parentNode;
        String parentPath = ResourceUtil.getParent((String)path);
        Session session = (Session)this.resourceResolver.adaptTo(Session.class);
        if (!session.nodeExists(parentPath)) {
            String parentNodeType = this.remoteInstance.getPrimaryType(parentPath);
            parentNode = JcrUtils.getOrCreateByPath((String)parentPath, (String)parentNodeType, (String)parentNodeType, (Session)session, (boolean)false);
        } else {
            parentNode = session.getNode(parentPath);
        }
        return parentNode;
    }

    public Node ensureContentNode(CatalogItem catalogItem) throws RepositoryException, IOException, URISyntaxException {
        Node contentNode;
        String path = catalogItem.getPath();
        Node parentNode = this.ensureParent(path);
        if (catalogItem.hasContentResource()) {
            String nodeName = ResourceUtil.getName((String)path);
            String primaryType = catalogItem.getString("jcr:primaryType");
            if (parentNode.hasNode(nodeName)) {
                contentNode = parentNode.getNode(nodeName);
            } else {
                String[] mixins;
                contentNode = parentNode.addNode(nodeName, primaryType);
                for (String mx : mixins = catalogItem.getMixins()) {
                    contentNode.addMixin(mx);
                }
            }
        } else {
            contentNode = parentNode;
        }
        return contentNode;
    }

    public void importData(CatalogItem catalogItem, JsonObject jsonObject) throws RepositoryException, IOException, URISyntaxException {
        String path = catalogItem.getPath();
        log.debug("importing {}", (Object)path);
        Node contentNode = this.ensureContentNode(catalogItem);
        this.clearContent(contentNode);
        ImportOptions importOptions = this.getImportOptions();
        String nodeName = catalogItem.hasContentResource() ? "jcr:content" : ResourceUtil.getName((String)path);
        StringWriter sw = new StringWriter();
        try (JsonWriter writer = Json.createWriter((Writer)sw);){
            writer.write((JsonStructure)jsonObject);
        }
        ByteArrayInputStream contentStream = new ByteArrayInputStream(sw.toString().getBytes(StandardCharsets.UTF_8));
        this.importer.importContent(contentNode, nodeName + ".json", (InputStream)contentStream, importOptions, null);
    }

    public String createVersion(Resource resource) throws Exception {
        String revisionId = null;
        if (resource.isResourceType("cq:Page")) {
            PageManager pageManager = (PageManager)this.resourceResolver.adaptTo(PageManager.class);
            Page pg = (Page)resource.adaptTo(Page.class);
            if (pg != null) {
                revisionId = pageManager.createRevision(pg, null, "created by contentsync").getId();
            }
        } else if (resource.isResourceType("dam:Asset")) {
            AssetManager assetManager = (AssetManager)this.resourceResolver.adaptTo(AssetManager.class);
            Asset asset = (Asset)resource.adaptTo(Asset.class);
            revisionId = assetManager.createRevision(asset, null, "created by contentsync").getId();
        }
        return revisionId;
    }

    public void runWorkflows(String workflowModel, List<String> paths) throws WorkflowException {
        WorkflowSession workflowSession = (WorkflowSession)this.resourceResolver.adaptTo(WorkflowSession.class);
        WorkflowModel model = workflowSession.getModel(workflowModel);
        for (String path : paths) {
            WorkflowData data = workflowSession.newWorkflowData("JCR_PATH", (Object)path);
            workflowSession.startWorkflow(model, data);
        }
    }
}

