/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentsync.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, immediate=true, property={"sling.servlet.extensions=json", "sling.servlet.selectors=catalog", "sling.servlet.resourceTypes=acs-commons/components/utilities/contentsync"})
public class ContentCatalogServlet
extends SlingSafeMethodsServlet {
    public static final String JOB_ID = "jobId";
    public static final String JOB_STATUS = "status";
    public static final String JOB_RESOURCES = "resources";
    @Reference
    private JobManager jobManager;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        Job job;
        response.setContentType("application/json");
        JsonObjectBuilder result = Json.createObjectBuilder();
        String jobId = request.getParameter(JOB_ID);
        if (jobId == null) {
            job = this.submitJob(request);
            result.add(JOB_ID, job.getId());
            result.add(JOB_STATUS, job.getJobState().toString());
        } else {
            job = this.jobManager.getJobById(jobId);
            result.add(JOB_ID, jobId);
            if (job != null) {
                result.add(JOB_STATUS, job.getJobState().toString());
                String resultMessage = (String)job.getProperty("slingevent:resultMessage");
                if (resultMessage != null) {
                    result.add("error", resultMessage);
                }
            } else {
                result.add(JOB_STATUS, Job.JobState.SUCCEEDED.toString());
                JsonObject results = this.getJobResults(request.getResourceResolver(), jobId);
                result.add(JOB_RESOURCES, (JsonValue)results.getJsonArray(JOB_RESOURCES));
            }
        }
        try (JsonWriter out = Json.createWriter((Writer)response.getWriter());){
            out.writeObject(result.build());
        }
    }

    Job submitJob(SlingHttpServletRequest request) {
        HashMap jobProps = new HashMap();
        request.getParameterMap().forEach((key, value) -> jobProps.put(key, value[0]));
        return this.jobManager.addJob("acs-commons/contentsync", jobProps);
    }

    JsonObject getJobResults(ResourceResolver resourceResolver, String jobId) throws IOException {
        String resultsPath = ContentCatalogServlet.getJobResultsPath(jobId);
        Resource resultsNode = resourceResolver.getResource(resultsPath);
        if (resultsNode == null) {
            throw new ResourceNotFoundException(resultsPath);
        }
        try (InputStream inputStream = (InputStream)resultsNode.adaptTo(InputStream.class);){
            JsonObject jsonObject;
            block13: {
                JsonReader reader = Json.createReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                try {
                    jsonObject = reader.readObject();
                    if (reader == null) break block13;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return jsonObject;
        }
    }

    public static String getJobResultsPath(String jobId) {
        return "/var/acs-commons/contentsync/jobs/" + jobId + "/results";
    }
}

