/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.http.impl;

import com.adobe.acs.commons.http.HttpClientFactory;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpHost;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component
public class HttpClientFactoryImpl
implements HttpClientFactory {
    private final HttpClientBuilder builder;
    private final HttpHost httpHost;
    private final Credentials credentials;
    private final String baseUrl;
    private Executor executor;
    private CloseableHttpClient httpClient;

    @Activate
    public HttpClientFactoryImpl(Config config, @Reference HttpClientBuilderFactory httpClientBuilderFactory) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        this(config.use_ssl(), config.hostname(), config.port(), config.so_timeout(), config.conn_timeout(), config.disable_certificate_check(), config.username(), config.password(), httpClientBuilderFactory);
    }

    HttpClientFactoryImpl(boolean useSSL, String hostname, int port, int soTimeout, int connectTimeout, boolean disableCertCheck, String username, String password, HttpClientBuilderFactory httpClientBuilderFactory) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        String scheme;
        String string = scheme = useSSL ? "https" : "http";
        if (hostname == null || port == 0) {
            throw new IllegalArgumentException("Configuration not valid. Both host and port must be provided.");
        }
        this.baseUrl = String.format("%s://%s:%s", scheme, hostname, port);
        this.builder = httpClientBuilderFactory.newBuilder();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(soTimeout).build();
        this.builder.setDefaultRequestConfig(requestConfig);
        if (useSSL && disableCertCheck) {
            SSLContextBuilder sslbuilder = new SSLContextBuilder();
            sslbuilder.loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslbuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            this.builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        this.httpHost = new HttpHost(hostname, port, useSSL ? "https" : "http");
        this.credentials = username != null && password != null ? new UsernamePasswordCredentials(username, password) : null;
    }

    synchronized Executor createExecutor() {
        this.httpClient = this.builder.build();
        this.executor = Executor.newInstance((HttpClient)this.httpClient);
        if (this.credentials != null) {
            this.executor.auth(this.httpHost, this.credentials).authPreemptive(this.httpHost);
        }
        return this.executor;
    }

    @Deactivate
    protected void deactivate() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void customize(Consumer<HttpClientBuilder> builderCustomizer) {
        if (this.httpClient != null) {
            throw new IllegalStateException("The underlying http client has already been created through a call of getExecutor() and can no longer be customized");
        }
        builderCustomizer.accept(this.builder);
    }

    @Override
    public Executor getExecutor() {
        if (this.executor == null) {
            this.executor = this.createExecutor();
        }
        return this.executor;
    }

    @Override
    public Request get(String partialUrl) {
        String url = this.baseUrl + partialUrl;
        return Request.Get((String)url);
    }

    @Override
    public Request post(String partialUrl) {
        String url = this.baseUrl + partialUrl;
        return Request.Post((String)url);
    }

    @Override
    public Request put(String partialUrl) {
        String url = this.baseUrl + partialUrl;
        return Request.Put((String)url);
    }

    @Override
    public Request delete(String partialUrl) {
        String url = this.baseUrl + partialUrl;
        return Request.Delete((String)url);
    }

    @Override
    public Request options(String partialUrl) {
        String url = this.baseUrl + partialUrl;
        return Request.Options((String)url);
    }

    @ObjectClassDefinition(factoryPid={"com.adobe.acs.commons.http.impl.HttpClientFactoryImpl"}, name="ACS AEM Commons - Http Components Fluent Executor Factory", description="ACS AEM Commons - Http Components Fluent Executor Factory")
    static @interface Config {
        @AttributeDefinition(name="Factory Name", description="Name of this factory")
        public String factory_name();

        @AttributeDefinition(name="host name", description="Mandatory")
        public String hostname();

        @AttributeDefinition(name="port", description="Mandatory")
        public int port();

        @AttributeDefinition(name="Use SSL", description="Select it if only using https connection for calls.")
        public boolean use_ssl() default false;

        @AttributeDefinition(name="Disable certificate ceck", description="If selected it will disable certificate check for the SSL connection.")
        public boolean disable_certificate_check() default false;

        @AttributeDefinition(name="Username", description="Username for requests (using basic authentication)")
        public String username();

        @AttributeDefinition(name="Password", description="Password for requests (using basic authentication)", type=AttributeType.PASSWORD)
        public String password();

        @AttributeDefinition(name="Socket Timeout", description="Socket timeout in milliseconds")
        public int so_timeout() default 30000;

        @AttributeDefinition(name="Connect Timeout", description="Connect timeout in milliseconds")
        public int conn_timeout() default 30000;

        public String webconsole_configurationFactory_nameHint() default "Factory Name: {factory.name}";
    }
}

