/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.FileUploadComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.impl.processes.TagCreator;
import com.adobe.acs.commons.mcp.model.GenericBlobReport;
import com.adobe.acs.commons.mcp.util.StringUtil;
import com.day.cq.tagging.Tag;
import com.day.cq.wcm.api.Page;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkPageTagger
extends ProcessDefinition
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(BulkPageTagger.class);
    private static final long serialVersionUID = 798823856839772874L;
    public static final String NAME = "Bulk Page Tagger";
    @FormField(name="Excel File", description="Provide the .xlsx file that defines the content pages and the corresponding cq:tags to be added on the pages", component=FileUploadComponent.class, options={"mimeTypes=application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "required"})
    public transient InputStream excelFile = null;
    volatile transient HashMap<String, String> pageTagMapping = new LinkedHashMap<String, String>();
    private final transient GenericBlobReport report = new GenericBlobReport();
    private final transient ArrayList<EnumMap<ReportColumns, Object>> reportRows = new ArrayList();

    @Override
    public void init() throws RepositoryException {
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException {
        this.report.setName(instance.getName());
        instance.getInfo().setDescription("Bulk Tag AEM content Pages");
        instance.defineCriticalAction("Parse Excel File", rr, this::parseExcel);
        instance.defineCriticalAction("Add Tags to Content Pages", rr, this::tagPages);
    }

    public void parseExcel(ActionManager manager) throws Exception {
        manager.withResolver(rr -> {
            Row row;
            XSSFWorkbook workbook = new XSSFWorkbook(this.excelFile);
            XSSFSheet sheet = workbook.getSheetAt(0);
            Iterator rows = sheet.rowIterator();
            String tagsRootPath = new TagCreator.TagRootResolver((ResourceResolver)rr).getTagsLocationPath();
            if (tagsRootPath == null) {
                this.recordAction(ReportRowSatus.FAILED_TO_PARSE, "Abandoning Tag parsing. Unable to determine AEM Tags root (/content/cq:tags vs /etc/tags). Please ensure the path exists and is accessible by the user running Tag Creator.", "N/A");
                return;
            }
            while (rows.hasNext() && (row = (Row)rows.next()).getCell(0) != null) {
                if (row.getRowNum() == 0 || row.getCell(0) == null) continue;
                this.pageTagMapping.put(row.getCell(0).getStringCellValue(), row.getCell(1).getStringCellValue());
            }
        });
    }

    public void tagPages(ActionManager manager) throws Exception {
        manager.withResolver(rr -> this.pageTagMapping.forEach((key, value) -> {
            Page page;
            Resource resource = rr.getResource(key);
            if (resource != null && (page = (Page)resource.adaptTo(Page.class)) != null) {
                Tag[] existingPageTags = page.getTags();
                String[] tagIds = (String[])Stream.of(existingPageTags).map(Tag::getTagID).toArray(String[]::new);
                Set updatedTags = Arrays.stream(value.split("[;\n]")).map(String::trim).collect(Collectors.toSet());
                updatedTags.addAll(Arrays.asList(tagIds));
                Object[] updatedTagsArray = (String[])updatedTags.stream().toArray(String[]::new);
                ModifiableValueMap properties = (ModifiableValueMap)page.getContentResource().adaptTo(ModifiableValueMap.class);
                properties.put((Object)"cq:tags", (Object)updatedTagsArray);
                try {
                    rr.commit();
                    ReportRowSatus status = ReportRowSatus.UPDATED_EXISTING;
                    this.recordAction(status, page.getPath(), Arrays.toString(updatedTagsArray));
                }
                catch (PersistenceException e) {
                    ReportRowSatus status = ReportRowSatus.FAILED_TO_UPDATE;
                    this.recordAction(status, page.getPath(), Arrays.toString(updatedTagsArray));
                    log.error(String.format("Unable to add tags to page with page path - %s ", page.getPath()));
                }
            }
        }));
    }

    private void recordAction(ReportRowSatus status, String pagePath, String tags) {
        EnumMap<ReportColumns, String> row = new EnumMap<ReportColumns, String>(ReportColumns.class);
        row.put(ReportColumns.STATUS, StringUtil.getFriendlyName(status.name()));
        row.put(ReportColumns.PAGE_PATH, pagePath);
        row.put(ReportColumns.TAGS_ARRAY, tags);
        this.reportRows.add(row);
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        this.report.setRows(this.reportRows, ReportColumns.class);
        this.report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    public static enum ReportRowSatus {
        CREATED,
        UPDATED_EXISTING,
        FAILED_TO_PARSE,
        FAILED_TO_UPDATE;

    }

    private static enum ReportColumns {
        STATUS,
        PAGE_PATH,
        TAGS_ARRAY;

    }
}

