/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.model;

import com.adobe.acs.commons.mcp.model.AbstractReport;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ChildResource;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@ProviderType
public class GenericReport
extends AbstractReport {
    public static final String GENERIC_REPORT_RESOURCE_TYPE = "acs-commons/components/utilities/process-instance/process-generic-report";
    @ValueMapValue
    private List<String> columns;
    @ChildResource
    private List<ValueMap> rows;
    @ValueMapValue
    private String name = "report";

    public String getResourceType() {
        return GENERIC_REPORT_RESOURCE_TYPE;
    }

    @PostConstruct
    public void init() {
        this.columnsData = this.columns;
        this.rowsData = this.rows;
    }

    @Override
    public void persist(ResourceResolver rr, String path) throws PersistenceException, RepositoryException {
        ModifiableValueMap jcrContent = (ModifiableValueMap)ResourceUtil.getOrCreateResource((ResourceResolver)rr, (String)path, (String)this.getResourceType(), null, (boolean)false).adaptTo(ModifiableValueMap.class);
        jcrContent.put((Object)"jcr:primaryType", (Object)"nt:unstructured");
        jcrContent.put((Object)"columns", (Object)this.getColumns().toArray(new String[0]));
        jcrContent.put((Object)"name", (Object)this.name);
        rr.commit();
        rr.refresh();
        JcrUtil.createPath((String)(path + "/rows"), (String)"nt:unstructured", (Session)((Session)rr.adaptTo(Session.class)));
        int rowCounter = 0;
        for (Map map : this.getRows()) {
            Map<String, Object> properties = map.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ResourceUtil.getOrCreateResource((ResourceResolver)rr, (String)(path + "/rows/row-" + ++rowCounter), properties, null, (boolean)true);
        }
        rr.commit();
        rr.refresh();
    }
}

