/*
 * ACS AEM Commons
 *
 * Copyright (C) 2013 - 2023 Adobe
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.adobe.acs.commons.adobeio.service.impl;

/**
 * List of constants used in the Adobe I/O connection
 */
public final class AdobeioConstants {

   public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
   
   public static final String CONTENT_TYPE_URL_ENCODED = "application/x-www-form-urlencoded";

   public static final String X_API_KEY = "X-Api-Key";
   
   public static final String CLIENT_ID = "client_id";
   
   public static final String CLIENT_SECRET = "client_secret";
   
   public static final String JWT_TOKEN = "jwt_token";
   
   public static final String AUTHORIZATION = "authorization";
   
   public static final String BEARER = "Bearer ";
   
   public static final String CACHE_CONTRL = "cache-control";
   
   public static final String NO_CACHE = "no-cache";
   
   public static final String CONTENT_TYPE = "content-type";

   public static final String JSON_ACCESS_TOKEN = "access_token";
   public static final String JK_PKEY = "PKey";
   public static final String JK_SUBSCRIBER = "subscriber";

   public static final String RESULT_ERROR = "error";
   public static final String RESULT_NO_DATA = "nodata";

   private AdobeioConstants() {
   }

}
