/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.functions;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobin<T>
implements Iterable<T> {
    private final List<T> items;

    public RoundRobin(List<T> coll) {
        this.items = Collections.unmodifiableList(coll);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final AtomicInteger index = new AtomicInteger(0);

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public synchronized T next() {
                int idx = this.index.getAndUpdate(x -> {
                    if (x == Integer.MAX_VALUE) {
                        return x % RoundRobin.this.items.size() + 1;
                    }
                    return ++x;
                });
                return RoundRobin.this.items.get(idx % RoundRobin.this.items.size());
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("remove not allowed");
            }
        };
    }
}

