/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.granite.ui.components.impl.include;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={Filter.class}, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"sling.filter.scope=INCLUDE"})
@Designate(ocd=Config.class)
public class IncludeDecoratorFilterImpl
implements Filter {
    static final String RESOURCE_TYPE = "acs-commons/granite/ui/components/include";
    static final String REQ_ATTR_NAMESPACE = "ACS_AEM_COMMONS_INCLUDE_NAMESPACE";
    static final String NN_PARAMETERS = "parameters";
    static final String PN_NAMESPACE = "namespace";
    static final String PREFIX = "ACS_AEM_COMMONS_INCLUDE_PREFIX_";
    static final String REQ_ATTR_IGNORE_CHILDREN_RESOURCE_TYPE = "ACS_AEM_COMMONS_EXCLUDE_CHILDREN_RESOURCE_TYPE";
    private List<String> resourceTypesIgnoreChildren;

    @Activate
    @Modified
    public void init(Config config) {
        this.resourceTypesIgnoreChildren = Arrays.asList(config.resourceTypesIgnoreChildren());
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        ValueMap parameters = ValueMap.EMPTY;
        if (servletRequest instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest request = (SlingHttpServletRequest)servletRequest;
            Predicate<String> typeCheckFn = resourceType -> request.getResourceResolver().isResourceType(request.getResource(), resourceType);
            if (typeCheckFn.test(RESOURCE_TYPE)) {
                this.performFilter(request, servletResponse, chain, parameters);
                return;
            }
            if (this.resourceTypesIgnoreChildren.stream().anyMatch(typeCheckFn)) {
                boolean ignoreChildren = this.resourceTypesIgnoreChildren.stream().anyMatch(typeCheckFn);
                if (ignoreChildren) {
                    request.setAttribute(REQ_ATTR_IGNORE_CHILDREN_RESOURCE_TYPE, (Object)request.getResource().getResourceType());
                }
                chain.doFilter(servletRequest, servletResponse);
                if (ignoreChildren) {
                    request.removeAttribute(REQ_ATTR_IGNORE_CHILDREN_RESOURCE_TYPE);
                }
                return;
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    private void performFilter(SlingHttpServletRequest request, ServletResponse servletResponse, FilterChain chain, ValueMap parameters) throws IOException, ServletException {
        Resource parameterResource = request.getResource().getChild(NN_PARAMETERS);
        if (parameterResource != null) {
            parameters = parameterResource.getValueMap();
        }
        ValueMap includeProperties = request.getResource().getValueMap();
        Object existingNamespace = request.getAttribute(REQ_ATTR_NAMESPACE);
        boolean hasExistingNamespace = existingNamespace != null;
        boolean hasNamespaceInInclude = includeProperties.containsKey((Object)PN_NAMESPACE);
        if (MapUtils.isNotEmpty((Map)parameters)) {
            parameters.forEach((key, object) -> request.setAttribute(PREFIX + key, object));
        }
        if (hasNamespaceInInclude && hasExistingNamespace) {
            request.setAttribute(REQ_ATTR_NAMESPACE, (Object)(existingNamespace + "/" + (String)includeProperties.get(PN_NAMESPACE, String.class)));
        } else if (hasNamespaceInInclude) {
            request.setAttribute(REQ_ATTR_NAMESPACE, includeProperties.get(PN_NAMESPACE, String.class));
        }
        chain.doFilter((ServletRequest)request, servletResponse);
        if (MapUtils.isNotEmpty((Map)parameters)) {
            parameters.forEach((key, object) -> request.removeAttribute(PREFIX + key));
        }
        if (existingNamespace != null) {
            request.setAttribute(REQ_ATTR_NAMESPACE, existingNamespace);
        } else {
            request.removeAttribute(REQ_ATTR_NAMESPACE);
        }
    }

    public void destroy() {
    }

    @ObjectClassDefinition(name="ACS AEM Commons - IncludeDecoratorFilterImpl", description="Used to perform the namespacing / parameterization in the include context")
    public static @interface Config {
        public String[] resourceTypesIgnoreChildren() default {"granite/ui/components/coral/foundation/form/multifield"};
    }
}

