/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import acscommons.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

@Model(adaptables={SlingHttpServletRequest.class})
public class Redirects {
    public static final String CFG_PROP_CONTEXT_PREFIX = "contextPrefix";
    @SlingObject
    private SlingHttpServletRequest request;
    int pageNumber = 1;
    int pageSize = 1000;
    List<List<Resource>> pages;
    String contextPrefix;

    @PostConstruct
    protected void init() {
        String pg = this.request.getParameter("page");
        if (pg != null) {
            this.pageNumber = Integer.parseInt(pg);
        }
        Resource configResource = this.request.getRequestPathInfo().getSuffixResource();
        ArrayList all = new ArrayList();
        configResource.listChildren().forEachRemaining(all::add);
        this.pages = Lists.partition(all, this.pageSize);
        ValueMap properties = configResource.getValueMap();
        this.contextPrefix = (String)properties.get(CFG_PROP_CONTEXT_PREFIX, (Object)"");
    }

    public List<Resource> getItems() {
        return this.pages.isEmpty() ? Collections.emptyList() : this.pages.get(this.pageNumber - 1);
    }

    public boolean isPaginated() {
        return this.pages.size() > 1;
    }

    public int getPages() {
        return this.pages.size();
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public boolean hasNext() {
        return this.pageNumber < this.pages.size();
    }

    public int getNextPage() {
        return this.pageNumber + 1;
    }

    public boolean hasPrevious() {
        return this.pageNumber > 1;
    }

    public int getPreviousPage() {
        return this.pageNumber - 1;
    }

    public String getContextPrefix() {
        return this.contextPrefix;
    }
}

